/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services;

import org.eclipse.lemminx.client.LimitExceededWarner;
import org.eclipse.lemminx.client.LimitFeature;
import org.eclipse.lemminx.services.AbstractNotifierTest;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LimitExceededWarnerTest
extends AbstractNotifierTest {
    private final LimitFeature TEST_FEATURE = LimitFeature.SYMBOLS;
    private static final int TEST_LIMIT = 0;
    private LimitExceededWarner limitExceededWarner;

    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.limitExceededWarner = this.getTextDocumentService().getLimitExceededWarner();
    }

    @Test
    public void testSendActionableNotification() {
        String uri1 = "file:///uri1.xml";
        String uri2 = "file:///uri2.xml";
        this.setSupportCapabilities(true, true);
        this.sendNotification(uri1);
        this.assertCounts(1, 0);
        this.sendNotification(uri1);
        this.assertCounts(1, 0);
        this.sendNotification(uri2);
        this.assertCounts(2, 0);
        this.sendNotification(uri2);
        this.assertCounts(2, 0);
    }

    @Test
    public void testActionableNotificationEvict() {
        String uri1 = "file:///uri1.xml";
        String uri2 = "file:///uri2.xml";
        this.setSupportCapabilities(true, true);
        this.sendNotification(uri1);
        this.assertCounts(1, 0);
        this.sendNotification(uri2);
        this.assertCounts(2, 0);
        this.getTextDocumentService().getLimitExceededWarner().evictValue(uri1);
        this.sendNotification(uri1);
        this.assertCounts(3, 0);
        this.sendNotification(uri2);
        this.assertCounts(3, 0);
        this.getTextDocumentService().getLimitExceededWarner().evictValue(uri2);
        this.sendNotification(uri1);
        this.assertCounts(3, 0);
        this.sendNotification(uri2);
        this.assertCounts(4, 0);
    }

    @Test
    public void testSendMessage() {
        String uri1 = "file:///uri1.xml";
        String uri2 = "file:///uri2.xml";
        this.setSupportCapabilities(false, false);
        this.sendNotification(uri1);
        this.assertCounts(0, 1);
        this.sendNotification(uri1);
        this.assertCounts(0, 1);
        this.sendNotification(uri2);
        this.assertCounts(0, 2);
        this.sendNotification(uri2);
        this.assertCounts(0, 2);
    }

    @Test
    public void testSendMessage2() {
        String uri = "file:///uri.xml";
        this.setSupportCapabilities(true, false);
        this.sendNotification(uri);
        this.assertCounts(0, 1);
    }

    @Test
    public void testSendMessage3() {
        String uri = "file:///uri.xml";
        this.setSupportCapabilities(false, true);
        this.sendNotification(uri);
        this.assertCounts(0, 1);
    }

    @Test
    public void testSendMessageEvict() {
        String uri1 = "file:///uri1.xml";
        String uri2 = "file:///uri2.xml";
        this.setSupportCapabilities(false, false);
        this.sendNotification(uri1);
        this.assertCounts(0, 1);
        this.sendNotification(uri2);
        this.assertCounts(0, 2);
        this.getTextDocumentService().getLimitExceededWarner().evictValue(uri1);
        this.sendNotification(uri1);
        this.assertCounts(0, 3);
        this.sendNotification(uri2);
        this.assertCounts(0, 3);
        this.getTextDocumentService().getLimitExceededWarner().evictValue(uri2);
        this.sendNotification(uri1);
        this.assertCounts(0, 3);
        this.sendNotification(uri2);
        this.assertCounts(0, 4);
    }

    private void sendNotification(String uri) {
        this.limitExceededWarner.onResultLimitExceeded(uri, 0, this.TEST_FEATURE);
    }
}

