/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.utils;

import java.util.List;
import org.eclipse.lemminx.services.extensions.ISharedSettingsRequest;
import org.eclipse.lemminx.utils.MarkdownConverter;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Range;

public class MarkupContentFactory {
    public static final String MARKDOWN_SEPARATOR = "___";

    public static MarkupContent createMarkupContent(String value, String preferredKind, ISharedSettingsRequest support) {
        if (value == null) {
            return null;
        }
        MarkupContent content = new MarkupContent();
        if ("markdown".equals(preferredKind) && support.canSupportMarkupKind(preferredKind)) {
            String markdown = MarkdownConverter.convert(value);
            content.setValue(markdown);
            content.setKind("markdown");
        } else {
            content.setValue(value);
            content.setKind("plaintext");
        }
        return content;
    }

    public static Hover createHover(List<MarkupContent> values) {
        return MarkupContentFactory.createHover(values, null);
    }

    public static Hover createHover(List<MarkupContent> values, Range defaultRange) {
        if (values.isEmpty()) {
            return null;
        }
        if (values.size() == 1) {
            return new Hover(values.get(0), defaultRange);
        }
        boolean hasMarkdown = values.stream().anyMatch(contents -> "markdown".equals(contents.getKind()));
        String markupKind = hasMarkdown ? "markdown" : "plaintext";
        String content = MarkupContentFactory.createContent(values, markupKind);
        Range range = defaultRange;
        return new Hover(new MarkupContent(markupKind, content), range);
    }

    private static String createContent(List<MarkupContent> values, String markupKind) {
        StringBuilder content = new StringBuilder();
        for (MarkupContent value : values) {
            if (StringUtils.isEmpty(value.getValue())) continue;
            if (content.length() > 0) {
                if (markupKind.equals("markdown")) {
                    content.append(System.lineSeparator());
                    content.append(System.lineSeparator());
                    content.append(MARKDOWN_SEPARATOR);
                }
                content.append(System.lineSeparator());
                content.append(System.lineSeparator());
            }
            content.append(value.getValue());
        }
        return content.toString();
    }
}

