/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.grammar.rng;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.util.URI;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.extensions.relaxng.utils.RelaxNGUtils;
import org.eclipse.lemminx.services.extensions.IDocumentLinkParticipant;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.DocumentLink;

public class RNGDocumentLinkParticipant
implements IDocumentLinkParticipant {
    private static final Logger LOGGER = Logger.getLogger(RNGDocumentLinkParticipant.class.getName());

    @Override
    public void findDocumentLinks(DOMDocument document, List<DocumentLink> links) {
        if (!DOMUtils.isRelaxNGXMLSyntax(document)) {
            return;
        }
        this.findDocumentLinks(document, document, links);
    }

    public void findDocumentLinks(DOMNode parent, DOMDocument document, List<DocumentLink> links) {
        for (DOMNode child : parent.getChildren()) {
            DOMAttr hrefAttr;
            if (!child.isElement()) continue;
            DOMElement rngElement = (DOMElement)child;
            if ((RelaxNGUtils.isInclude(rngElement) || RelaxNGUtils.isExternalRef(rngElement)) && (hrefAttr = RelaxNGUtils.getHref(rngElement)) != null && !StringUtils.isEmpty(hrefAttr.getValue())) {
                String location = RNGDocumentLinkParticipant.getResolvedLocation(document.getDocumentURI(), hrefAttr.getValue());
                DOMRange hrefRange = hrefAttr.getNodeAttrValue();
                try {
                    links.add(XMLPositionUtility.createDocumentLink(hrefRange, location, true));
                }
                catch (BadLocationException e) {
                    LOGGER.log(Level.SEVERE, "Creation of document link failed", e);
                }
            }
            this.findDocumentLinks(rngElement, document, links);
        }
    }

    private static String getResolvedLocation(String documentURI, String location) {
        if (location == null) {
            return null;
        }
        try {
            return XMLEntityManager.expandSystemId((String)location, (String)documentURI, (boolean)false);
        }
        catch (URI.MalformedURIException e) {
            return location;
        }
    }
}

