/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.codeactions;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.CodeActionFactory;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.codeaction.ICodeActionRequest;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class cvc_elt_1_aCodeAction
implements ICodeActionParticipant {
    @Override
    public void doCodeAction(ICodeActionRequest request, List<CodeAction> codeActions, CancelChecker cancelChecker) {
        DOMDocument document = request.getDocument();
        Diagnostic diagnostic = request.getDiagnostic();
        try {
            DOMElement unexpectedElement = document.getDocumentElement();
            if (unexpectedElement == null) {
                return;
            }
            String unexpectedElementText = unexpectedElement.getNodeName();
            Range diagnosticRange = diagnostic.getRange();
            int startOffset = document.offsetAt(diagnosticRange.getStart()) + 1;
            DOMNode node = document.findNodeAt(startOffset);
            if (node == null || !node.isElement()) {
                return;
            }
            DOMElement element = (DOMElement)node;
            ContentModelManager contentModelManager = (ContentModelManager)request.getComponent(ContentModelManager.class);
            TreeSet<Object> expectedElements = new TreeSet<Object>(Collator.getInstance());
            for (CMDocument cmDocument : contentModelManager.findCMDocument(element)) {
                Collection<CMElementDeclaration> elementDeclaration = cmDocument.getElements();
                for (CMElementDeclaration cMElementDeclaration : elementDeclaration) {
                    expectedElements.add(cMElementDeclaration.getLocalName());
                }
            }
            ArrayList<Range> ranges = new ArrayList<Range>();
            Range startRange = XMLPositionUtility.selectStartTagName(node);
            Range endRange = XMLPositionUtility.selectEndTagName(element);
            ranges.add(startRange);
            if (endRange != null) {
                ranges.add(endRange);
            }
            for (String string : expectedElements) {
                CodeAction addReplaceRootElement = CodeActionFactory.replaceAt("Replace '" + unexpectedElementText + "' with '" + string + "'", string, document.getTextDocument(), diagnostic, ranges);
                codeActions.add(addReplaceRootElement);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

