/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd.participants.diagnostics;

import java.util.List;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.extensions.xerces.LSPXMLEntityResolver;
import org.eclipse.lemminx.extensions.xsd.XSDPlugin;
import org.eclipse.lemminx.extensions.xsd.participants.diagnostics.XSDValidator;
import org.eclipse.lemminx.services.extensions.diagnostics.DiagnosticsResult;
import org.eclipse.lemminx.services.extensions.diagnostics.IDiagnosticsParticipant;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class XSDDiagnosticsParticipant
implements IDiagnosticsParticipant {
    private final XSDPlugin xsdPlugin;

    public XSDDiagnosticsParticipant(XSDPlugin xsdPlugin) {
        this.xsdPlugin = xsdPlugin;
    }

    @Override
    public void doDiagnostics(DOMDocument xmlDocument, List<Diagnostic> diagnostics, XMLValidationSettings validationSettings, CancelChecker cancelChecker) {
        if (!DOMUtils.isXSD(xmlDocument)) {
            return;
        }
        URIResolverExtensionManager entityResolver = xmlDocument.getResolverExtensionManager();
        LSPXMLEntityResolver entityResolverWrapper = new LSPXMLEntityResolver(entityResolver, (DiagnosticsResult)diagnostics);
        XSDValidator.doDiagnostics(xmlDocument, entityResolverWrapper, diagnostics, validationSettings, this.xsdPlugin.getContentModelManager(), cancelChecker);
    }
}

