/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.references;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.references.XMLReferences;

public class XMLReferencesManager {
    private static final XMLReferencesManager INSTANCE = new XMLReferencesManager();
    private final List<XMLReferences> referencesCache = new ArrayList<XMLReferences>();

    public static XMLReferencesManager getInstance() {
        return INSTANCE;
    }

    public XMLReferences referencesFor(Predicate<DOMDocument> documentPredicate) {
        XMLReferences references = new XMLReferences(documentPredicate);
        this.referencesCache.add(references);
        return references;
    }

    public void collect(DOMNode node, Consumer<DOMNode> collector) {
        DOMDocument document = node.getOwnerDocument();
        for (XMLReferences references : this.referencesCache) {
            if (!references.canApply(document)) continue;
            try {
                references.collectNodes(node, collector);
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
        }
    }
}

