/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.dtd.DTDGrammar;
import org.apache.xerces.impl.dtd.XMLDTDDescription;
import org.apache.xerces.impl.dtd.XMLEntityDecl;
import org.apache.xerces.impl.validation.ValidationManager;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.eclipse.lemminx.extensions.contentmodel.participants.DTDErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPErrorReporterForXML;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPXMLGrammarPool;
import org.eclipse.lemminx.utils.FilesUtils;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class LSPSAXParser
extends SAXParser {
    protected static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    private final LSPErrorReporterForXML reporter;
    private final LSPXMLGrammarPool grammarPool;
    private List<XMLDTDDescription> grammarDescs;
    private XMLLocator locator;

    public LSPSAXParser(LSPErrorReporterForXML reporter, XMLParserConfiguration config, LSPXMLGrammarPool grammarPool) {
        super(config);
        this.reporter = reporter;
        this.grammarPool = grammarPool;
        this.init(reporter);
    }

    private void init(LSPErrorReporterForXML reporter) {
        try {
            super.setProperty("http://apache.org/xml/properties/internal/error-reporter", (Object)reporter);
            super.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
            super.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            super.setFeature("http://xml.org/sax/features/namespaces", true);
            super.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", true);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        this.locator = locator;
        super.startDocument(locator, encoding, namespaceContext, augs);
    }

    public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
        block7: {
            if (systemId != null) {
                XMLEntityManager entityManager = (XMLEntityManager)this.fConfiguration.getProperty(ENTITY_MANAGER);
                XMLDTDDescription grammarDesc = this.createGrammarDescription(rootElement, publicId, systemId);
                String eid = grammarDesc.getExpandedSystemId();
                try {
                    DTDGrammar grammar;
                    XMLInputSource input = entityManager.resolveEntity((XMLResourceIdentifier)grammarDesc);
                    String resolvedSystemId = input.getSystemId();
                    if (resolvedSystemId != null && resolvedSystemId.startsWith("file://") && !FilesUtils.toFile(resolvedSystemId).exists()) {
                        throw new FileNotFoundException(resolvedSystemId);
                    }
                    if (this.grammarPool != null && (grammar = (DTDGrammar)this.grammarPool.retrieveGrammar((XMLGrammarDescription)grammarDesc)) != null) {
                        LSPSAXParser.fillEntities(grammar, entityManager);
                    }
                }
                catch (Exception e) {
                    this.reporter.reportError(this.locator, "https://www.w3.org/TR/xml-model/", DTDErrorCode.dtd_not_found.getCode(), new Object[]{null, eid}, (short)1, e);
                    ValidationManager fValidationManager = (ValidationManager)this.fConfiguration.getProperty(VALIDATION_MANAGER);
                    if (fValidationManager != null) {
                        fValidationManager.setCachedDTD(true);
                    }
                    if (this.grammarPool == null) break block7;
                    if (this.grammarDescs == null) {
                        this.grammarDescs = new ArrayList<XMLDTDDescription>();
                    }
                    this.grammarDescs.add(grammarDesc);
                }
            }
        }
        super.doctypeDecl(rootElement, publicId, systemId, augs);
    }

    public void endDTD(Augmentations augs) throws XNIException {
        super.endDTD(augs);
        if (this.grammarDescs != null) {
            this.grammarDescs.forEach(desc -> this.grammarPool.removeGrammar((XMLGrammarDescription)desc));
        }
    }

    private XMLDTDDescription createGrammarDescription(String rootElement, String publicId, String systemId) {
        String eid = null;
        try {
            eid = XMLEntityManager.expandSystemId((String)systemId, (String)this.locator.getExpandedSystemId(), (boolean)false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new XMLDTDDescription(publicId, systemId, this.locator.getExpandedSystemId(), eid, rootElement);
    }

    private static void fillEntities(DTDGrammar grammar, final XMLEntityManager entityManager) {
        int index = 0;
        XMLEntityDecl entityDecl = new XMLEntityDecl(){

            public void setValues(String name, String publicId, String systemId, String baseSystemId, String notation, String value, boolean isPE, boolean inExternal) {
                if (inExternal) {
                    entityManager.addInternalEntity(name, value);
                }
            }
        };
        while (grammar.getEntityDecl(index, entityDecl)) {
            ++index;
        }
    }
}

