/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.client;

import java.net.URI;
import java.nio.file.Paths;
import java.util.Collections;
import org.eclipse.lemminx.client.AbstractXMLNotifier;
import org.eclipse.lemminx.client.IXMLSettingFeature;
import org.eclipse.lemminx.client.LimitFeature;
import org.eclipse.lemminx.services.IXMLNotificationService;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.MessageType;

public class LimitExceededWarner
extends AbstractXMLNotifier {
    public LimitExceededWarner(IXMLNotificationService notificationService) {
        super(notificationService);
    }

    public void onResultLimitExceeded(String uri, LimitFeature feature) {
        int resultLimit = 0;
        switch (feature) {
            case SYMBOLS: {
                resultLimit = this.getSharedSettings().getSymbolSettings().getMaxItemsComputed();
            }
        }
        this.onResultLimitExceeded(uri, resultLimit, feature);
    }

    public void onResultLimitExceeded(String uri, int resultLimit, LimitFeature feature) {
        if (this.existsInCache((IXMLSettingFeature)feature, uri)) {
            return;
        }
        this.sendLimitExceededWarning(uri, resultLimit, feature);
        this.addToCache(feature, uri);
    }

    private void sendLimitExceededWarning(String uri, int resultLimit, LimitFeature feature) {
        String filename = Paths.get(URI.create(uri)).getFileName().toString();
        String message = filename != null ? filename + ": " : "";
        message = message + "For performance reasons, " + feature.getName() + " have been limited to " + resultLimit + " items.\nIf a new limit is set, please close and reopen this file to recompute " + feature.getName() + ".";
        Command command = new Command("Configure limit", "xml.open.settings", Collections.singletonList(feature.getSettingId()));
        super.sendNotification(message, MessageType.Info, command);
    }
}

