/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.bluetooth.wrapper;

import com.github.hypfvieh.DbusHelper;
import com.github.hypfvieh.bluetooth.wrapper.AbstractBluetoothObject;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothDeviceType;
import java.util.Map;
import java.util.UUID;
import org.bluez.ProfileManager1;
import org.bluez.exceptions.BluezAlreadyExistsException;
import org.bluez.exceptions.BluezDoesNotExistException;
import org.bluez.exceptions.BluezInvalidArgumentsException;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileManager
extends AbstractBluetoothObject {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ProfileManager1 rawProfileManager;

    public ProfileManager(DBusConnection _dbusConnection) {
        super(BluetoothDeviceType.PROFILE_MANAGER, _dbusConnection, "/org/bluez");
        this.rawProfileManager = DbusHelper.getRemoteObject(_dbusConnection, this.getDbusPath(), ProfileManager1.class);
    }

    @Override
    protected Class<? extends DBusInterface> getInterfaceClass() {
        return ProfileManager1.class;
    }

    public boolean registerProfile(String _path, String _uuid, Map<String, Object> _options) {
        try {
            this.rawProfileManager.RegisterProfile(new DBusPath(_path), _uuid, this.optionsToVariantMap(_options));
            return true;
        }
        catch (BluezAlreadyExistsException e) {
            this.logger.debug("Profile already exists (UUID: {}, Path: {}).", new Object[]{_uuid, _path, e});
            return true;
        }
        catch (BluezInvalidArgumentsException e) {
            this.logger.error("Error while registering Profile (UUID: {}, Path: {}).", new Object[]{_uuid, _path, e});
            return false;
        }
    }

    public boolean unregisterProfile(UUID _uuid, String _path) {
        try {
            this.rawProfileManager.UnregisterProfile(new DBusPath(_path));
            return true;
        }
        catch (BluezDoesNotExistException e) {
            this.logger.trace("Profile does not exist (UUID: {}, Path: {}).", new Object[]{_uuid, _path, e});
            return false;
        }
    }
}

