/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.keystore.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.security.auth.x500.X500Principal;
import javax.ws.rs.WebApplicationException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.core.keystore.request.CsrReadRequest;
import org.eclipse.kura.core.keystore.util.CertificateInfo;
import org.eclipse.kura.core.keystore.util.CsrInfo;
import org.eclipse.kura.core.keystore.util.EntryInfo;
import org.eclipse.kura.core.keystore.util.KeyPairInfo;
import org.eclipse.kura.core.keystore.util.PrivateKeyInfo;
import org.eclipse.kura.security.keystore.KeystoreInfo;
import org.eclipse.kura.security.keystore.KeystoreService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeystoreRemoteService {
    private static final Logger logger = LoggerFactory.getLogger(KeystoreRemoteService.class);
    public static final String BEGIN_CERT = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT = "-----END CERTIFICATE-----";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected Map<String, KeystoreService> keystoreServices = new HashMap<String, KeystoreService>();
    protected BundleContext bundleContext;
    private ServiceTrackerCustomizer<KeystoreService, KeystoreService> keystoreServiceTrackerCustomizer;
    private ServiceTracker<KeystoreService, KeystoreService> keystoreServiceTracker;

    public void activate(ComponentContext componentContext) {
        this.bundleContext = componentContext.getBundleContext();
        this.keystoreServiceTrackerCustomizer = new KeystoreServiceTrackerCustomizer();
        this.initKeystoreServiceTracking();
    }

    public void deactivate(ComponentContext componentContext) {
        if (this.keystoreServiceTracker != null) {
            this.keystoreServiceTracker.close();
        }
    }

    public static KeyStore.TrustedCertificateEntry createCertificateEntry(String certificate) throws CertificateException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream is = new ByteArrayInputStream(certificate.getBytes(StandardCharsets.UTF_8));
        X509Certificate cert = (X509Certificate)certFactory.generateCertificate(is);
        return new KeyStore.TrustedCertificateEntry(cert);
    }

    public static KeyStore.PrivateKeyEntry createPrivateKey(String privateKey, String publicKey) throws IOException, GeneralSecurityException {
        Certificate[] certs = KeystoreRemoteService.parsePublicCertificates(publicKey);
        Security.addProvider((Provider)new BouncyCastleProvider());
        PEMParser pemParser = new PEMParser((Reader)new StringReader(privateKey));
        Object object = pemParser.readObject();
        pemParser.close();
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        PrivateKey privkey = null;
        if (object instanceof org.bouncycastle.asn1.pkcs.PrivateKeyInfo) {
            privkey = converter.getPrivateKey((org.bouncycastle.asn1.pkcs.PrivateKeyInfo)object);
        } else if (object instanceof PEMKeyPair) {
            privkey = converter.getKeyPair((PEMKeyPair)object).getPrivate();
        } else {
            throw new IOException("PrivateKey not recognized.");
        }
        return new KeyStore.PrivateKeyEntry(privkey, certs);
    }

    public static X509Certificate[] parsePublicCertificates(String certificates) throws CertificateException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream is = new ByteArrayInputStream(certificates.getBytes(StandardCharsets.UTF_8));
        Collection<? extends Certificate> decodedCertificates = certFactory.generateCertificates(is);
        ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
        for (Certificate certificate : decodedCertificates) {
            if (!(certificate instanceof X509Certificate)) {
                throw new CertificateException("Provided certificate is not a X509Certificate");
            }
            result.add((X509Certificate)certificate);
        }
        return result.toArray(new X509Certificate[result.size()]);
    }

    protected List<KeystoreInfo> listKeystoresInternal() {
        ArrayList<KeystoreInfo> keystores = new ArrayList<KeystoreInfo>();
        this.keystoreServices.entrySet().stream().forEach(entry -> {
            try {
                if (((KeystoreService)entry.getValue()).getKeyStore() != null) {
                    keystores.add(this.buildKeystoreInfo((String)entry.getKey(), ((KeystoreService)entry.getValue()).getKeyStore()));
                }
            }
            catch (KeyStoreException | KuraException e) {
                throw new WebApplicationException(e);
            }
        });
        return keystores;
    }

    protected List<EntryInfo> getKeysInternal() {
        ArrayList<EntryInfo> keys = new ArrayList<EntryInfo>();
        this.keystoreServices.entrySet().stream().forEach(keystoreService -> {
            if (keystoreService != null) {
                try {
                    ((KeystoreService)keystoreService.getValue()).getEntries().entrySet().stream().forEach(entry2 -> {
                        if (entry2.getValue() instanceof KeyStore.PrivateKeyEntry) {
                            keys.add(this.buildPrivateKeyInfo((String)keystoreService.getKey(), (String)entry2.getKey(), (KeyStore.PrivateKeyEntry)entry2.getValue(), false));
                        } else if (entry2.getValue() instanceof KeyStore.TrustedCertificateEntry) {
                            keys.add(this.buildCertificateInfo((String)keystoreService.getKey(), (String)entry2.getKey(), (KeyStore.TrustedCertificateEntry)entry2.getValue(), false));
                        }
                    });
                }
                catch (KuraException e) {
                    throw new WebApplicationException((Throwable)e);
                }
            }
        });
        return keys;
    }

    protected List<EntryInfo> getKeysByPidInternal(String keystoreServicePid) {
        ArrayList<EntryInfo> keys = new ArrayList<EntryInfo>();
        KeystoreService keystoreService = this.keystoreServices.get(keystoreServicePid);
        if (keystoreService != null) {
            try {
                keystoreService.getEntries().entrySet().stream().forEach(entry -> {
                    if (entry.getValue() instanceof KeyStore.PrivateKeyEntry) {
                        keys.add(this.buildPrivateKeyInfo(keystoreServicePid, (String)entry.getKey(), (KeyStore.PrivateKeyEntry)entry.getValue(), true));
                    } else if (entry.getValue() instanceof KeyStore.TrustedCertificateEntry) {
                        keys.add(this.buildCertificateInfo(keystoreServicePid, (String)entry.getKey(), (KeyStore.TrustedCertificateEntry)entry.getValue(), true));
                    }
                });
            }
            catch (KuraException e) {
                throw new WebApplicationException((Throwable)e);
            }
        } else {
            throw new WebApplicationException(404);
        }
        return keys;
    }

    protected List<EntryInfo> getKeysByAliasInternal(String alias) {
        ArrayList<EntryInfo> keys = new ArrayList<EntryInfo>();
        this.keystoreServices.entrySet().stream().filter(entry -> {
            try {
                return ((KeystoreService)entry.getValue()).getAliases().contains(alias);
            }
            catch (KuraException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }).forEach(entry -> {
            block4: {
                try {
                    KeyStore.Entry keystoreEntry = ((KeystoreService)entry.getValue()).getEntry(alias);
                    if (keystoreEntry instanceof KeyStore.PrivateKeyEntry) {
                        keys.add(this.buildPrivateKeyInfo((String)entry.getKey(), alias, (KeyStore.PrivateKeyEntry)keystoreEntry, true));
                        break block4;
                    }
                    if (keystoreEntry instanceof KeyStore.TrustedCertificateEntry) {
                        keys.add(this.buildCertificateInfo((String)entry.getKey(), alias, (KeyStore.TrustedCertificateEntry)keystoreEntry, true));
                        break block4;
                    }
                    throw new WebApplicationException(404);
                }
                catch (KuraException e) {
                    throw new WebApplicationException((Throwable)e);
                }
            }
        });
        return keys;
    }

    protected EntryInfo getKeyInternal(String keystoreServicePid, String alias) {
        KeystoreService keystoreService = this.keystoreServices.get(keystoreServicePid);
        if (keystoreService != null) {
            try {
                KeyStore.Entry entry = keystoreService.getEntry(alias);
                if (entry instanceof KeyStore.PrivateKeyEntry) {
                    return this.buildPrivateKeyInfo(keystoreServicePid, alias, (KeyStore.PrivateKeyEntry)entry, true);
                }
                if (entry instanceof KeyStore.TrustedCertificateEntry) {
                    return this.buildCertificateInfo(keystoreServicePid, alias, (KeyStore.TrustedCertificateEntry)entry, true);
                }
                throw new WebApplicationException(404);
            }
            catch (KuraException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
        throw new WebApplicationException(404);
    }

    protected String getCSRInternal(CsrInfo info) {
        try {
            X500Principal principal = new X500Principal(info.getAttributes());
            return this.keystoreServices.get(info.getKeystoreServicePid()).getCSR(info.getAlias(), principal, info.getSignatureAlgorithm());
        }
        catch (KuraException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    protected String getCSRInternal(CsrReadRequest request) {
        try {
            X500Principal principal = new X500Principal(request.getAttributes());
            return this.keystoreServices.get(request.getKeystoreServicePid()).getCSR(request.getAlias(), principal, request.getSignatureAlgorithm());
        }
        catch (KuraException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    protected void storeTrustedCertificateEntryInternal(CertificateInfo writeRequest) {
        try {
            this.keystoreServices.get(writeRequest.getKeystoreServicePid()).setEntry(writeRequest.getAlias(), (KeyStore.Entry)KeystoreRemoteService.createCertificateEntry(writeRequest.getCertificate()));
        }
        catch (GeneralSecurityException | KuraException e) {
            throw new WebApplicationException(e);
        }
    }

    protected void storeKeyPairEntryInternal(KeyPairInfo writeRequest) {
        try {
            this.keystoreServices.get(writeRequest.getKeystoreServicePid()).createKeyPair(writeRequest.getAlias(), writeRequest.getAlgorithm(), writeRequest.getSize(), writeRequest.getSignatureAlgorithm(), writeRequest.getAttributes());
        }
        catch (KuraException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    protected void storePrivateKeyEntryInternal(PrivateKeyInfo writeRequest) throws KuraException, IOException, GeneralSecurityException {
        KeystoreService targetKeystore = Optional.ofNullable(this.keystoreServices.get(writeRequest.getKeystoreServicePid())).orElseThrow(() -> new KuraException(KuraErrorCode.NOT_FOUND, new Object[]{"KeystoreService not found"}));
        if (writeRequest.getPrivateKey() == null) {
            this.updatePrivateKeyEntryCertificateChain(targetKeystore, writeRequest);
        } else {
            this.createPrivateKeyEntry(targetKeystore, writeRequest);
        }
    }

    private void updatePrivateKeyEntryCertificateChain(KeystoreService targetKeystore, PrivateKeyInfo writeRequest) throws KuraException, CertificateException {
        KeyStore.Entry targetEntry = Optional.ofNullable(targetKeystore.getEntry(writeRequest.getAlias())).orElseThrow(() -> new KuraException(KuraErrorCode.NOT_FOUND, new Object[]{"Entry not found"}));
        if (!(targetEntry instanceof KeyStore.PrivateKeyEntry)) {
            throw new KuraException(KuraErrorCode.BAD_REQUEST, new Object[]{"Target entry is not a PrivateKeyEntry"});
        }
        KeyStore.PrivateKeyEntry existingPrivateKeyEntry = (KeyStore.PrivateKeyEntry)targetEntry;
        Certificate[] certificateChain = KeystoreRemoteService.parsePublicCertificates(Arrays.stream(writeRequest.getCertificateChain()).collect(Collectors.joining("\n")));
        KeyStore.PrivateKeyEntry result = new KeyStore.PrivateKeyEntry(existingPrivateKeyEntry.getPrivateKey(), certificateChain);
        targetKeystore.setEntry(writeRequest.getAlias(), (KeyStore.Entry)result);
    }

    private void createPrivateKeyEntry(KeystoreService targetKeystore, PrivateKeyInfo writeRequest) throws IOException, GeneralSecurityException, KuraException {
        KeyStore.PrivateKeyEntry privateKeyEntry = KeystoreRemoteService.createPrivateKey(writeRequest.getPrivateKey(), Arrays.stream(writeRequest.getCertificateChain()).collect(Collectors.joining("\n")));
        targetKeystore.setEntry(writeRequest.getAlias(), (KeyStore.Entry)privateKeyEntry);
    }

    protected void deleteKeyEntryInternal(String keystoreServicePid, String alias) {
        try {
            this.keystoreServices.get(keystoreServicePid).deleteEntry(alias);
        }
        catch (KuraException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    private KeystoreInfo buildKeystoreInfo(String keystoreServicePid, KeyStore keystore) throws KeyStoreException {
        KeystoreInfo keystoreInfo = new KeystoreInfo(keystoreServicePid);
        keystoreInfo.setType(keystore.getType());
        keystoreInfo.setSize(keystore.size());
        return keystoreInfo;
    }

    private CertificateInfo buildCertificateInfo(String keystoreServicePid, String alias, KeyStore.TrustedCertificateEntry certificate, boolean withCertificate) {
        CertificateInfo certificateInfo = new CertificateInfo(keystoreServicePid, alias);
        if (certificate != null && certificate.getTrustedCertificate() instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)certificate.getTrustedCertificate();
            certificateInfo.setSubjectDN(x509Certificate.getSubjectDN().getName());
            certificateInfo.setIssuer(x509Certificate.getIssuerX500Principal().getName());
            certificateInfo.setStartDate(x509Certificate.getNotBefore().getTime());
            certificateInfo.setExpirationDate(x509Certificate.getNotAfter().getTime());
            certificateInfo.setAlgorithm(x509Certificate.getSigAlgName());
            certificateInfo.setSize(this.getSize(x509Certificate.getPublicKey()));
            try {
                certificateInfo.setSubjectAN(x509Certificate.getSubjectAlternativeNames());
            }
            catch (CertificateParsingException e) {
                logger.error("Cannot parse certificate subject alternative names", (Throwable)e);
            }
            if (withCertificate) {
                Base64.Encoder encoder = Base64.getMimeEncoder(64, LINE_SEPARATOR.getBytes(StandardCharsets.UTF_8));
                StringBuilder pemCertificate = new StringBuilder();
                pemCertificate.append(BEGIN_CERT);
                pemCertificate.append(LINE_SEPARATOR);
                try {
                    pemCertificate.append(encoder.encodeToString(x509Certificate.getEncoded()));
                }
                catch (CertificateEncodingException e) {
                    logger.error("Cannot encode certificate", (Throwable)e);
                }
                pemCertificate.append(LINE_SEPARATOR);
                pemCertificate.append(END_CERT);
                certificateInfo.setCertificate(pemCertificate.toString());
            }
        }
        return certificateInfo;
    }

    private PrivateKeyInfo buildPrivateKeyInfo(String keystoreServicePid, String alias, KeyStore.PrivateKeyEntry privateKey, boolean withCertificate) {
        PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(keystoreServicePid, alias);
        if (privateKey != null) {
            privateKeyInfo.setAlgorithm(privateKey.getPrivateKey().getAlgorithm());
            privateKeyInfo.setSize(this.getSize(privateKey.getCertificate().getPublicKey()));
            if (withCertificate) {
                Base64.Encoder encoder = Base64.getMimeEncoder(64, LINE_SEPARATOR.getBytes(StandardCharsets.UTF_8));
                String[] certificateChain = new String[privateKey.getCertificateChain().length];
                int i = 0;
                while (i < certificateChain.length) {
                    StringBuilder pemCertificate = new StringBuilder();
                    pemCertificate.append(BEGIN_CERT);
                    pemCertificate.append(LINE_SEPARATOR);
                    try {
                        pemCertificate.append(encoder.encodeToString(privateKey.getCertificateChain()[i].getEncoded()));
                    }
                    catch (CertificateEncodingException e) {
                        logger.error("Cannot encode certificate", (Throwable)e);
                    }
                    pemCertificate.append(LINE_SEPARATOR);
                    pemCertificate.append(END_CERT);
                    certificateChain[i] = pemCertificate.toString();
                    ++i;
                }
                privateKeyInfo.setCertificateChain(certificateChain);
            }
        }
        return privateKeyInfo;
    }

    private int getSize(Key key) {
        int size = 0;
        if (key instanceof RSAPublicKey) {
            size = ((RSAPublicKey)key).getModulus().bitLength();
        } else if (key instanceof ECPublicKey) {
            ECParameterSpec spec = ((ECPublicKey)key).getParams();
            if (spec != null) {
                size = spec.getOrder().bitLength();
            }
        } else if (key instanceof DSAPublicKey) {
            DSAPublicKey dsaCertificate = (DSAPublicKey)key;
            size = dsaCertificate.getParams() != null ? dsaCertificate.getParams().getP().bitLength() : dsaCertificate.getY().bitLength();
        }
        return size;
    }

    private void initKeystoreServiceTracking() {
        String filterString = String.format("(&(%s=%s))", "objectClass", KeystoreService.class.getName());
        Filter filter = null;
        try {
            filter = this.bundleContext.createFilter(filterString);
        }
        catch (InvalidSyntaxException e) {
            logger.error("Filter setup exception ", (Throwable)e);
        }
        this.keystoreServiceTracker = new ServiceTracker(this.bundleContext, filter, this.keystoreServiceTrackerCustomizer);
        this.keystoreServiceTracker.open();
    }

    private final class KeystoreServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<KeystoreService, KeystoreService> {
        private static final String KURA_SERVICE_PID = "kura.service.pid";

        private KeystoreServiceTrackerCustomizer() {
        }

        public KeystoreService addingService(ServiceReference<KeystoreService> reference) {
            String kuraServicePid = (String)reference.getProperty(KURA_SERVICE_PID);
            KeystoreRemoteService.this.keystoreServices.put(kuraServicePid, (KeystoreService)KeystoreRemoteService.this.bundleContext.getService(reference));
            return KeystoreRemoteService.this.keystoreServices.get(kuraServicePid);
        }

        public void modifiedService(ServiceReference<KeystoreService> reference, KeystoreService service) {
            String kuraServicePid = (String)reference.getProperty(KURA_SERVICE_PID);
            KeystoreRemoteService.this.keystoreServices.put(kuraServicePid, (KeystoreService)KeystoreRemoteService.this.bundleContext.getService(reference));
        }

        public void removedService(ServiceReference<KeystoreService> reference, KeystoreService service) {
            String kuraServicePid = (String)reference.getProperty(KURA_SERVICE_PID);
            KeystoreRemoteService.this.keystoreServices.remove(kuraServicePid);
        }
    }
}

