/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.type;

import java.util.Arrays;
import java.util.Objects;
import org.eclipse.kura.annotation.Immutable;
import org.eclipse.kura.annotation.ThreadSafe;
import org.eclipse.kura.type.DataType;
import org.eclipse.kura.type.TypedValue;
import org.osgi.annotation.versioning.ProviderType;

@Immutable
@ThreadSafe
@ProviderType
public class ByteArrayValue
implements TypedValue<byte[]> {
    private final byte[] value;

    public ByteArrayValue(byte[] value) {
        Objects.requireNonNull(value, "Provided Typed Value cannot be null");
        this.value = value;
    }

    @Override
    public int compareTo(TypedValue<byte[]> otherTypedValue) {
        Objects.requireNonNull(otherTypedValue, "Typed Value cannot be null");
        byte[] otherValue = otherTypedValue.getValue();
        int i = 0;
        int j = 0;
        while (i < this.value.length && j < otherValue.length) {
            int a = this.value[i] & 0xFF;
            int b = otherValue[j] & 0xFF;
            if (a != b) {
                return a - b;
            }
            ++i;
            ++j;
        }
        return this.value.length - otherValue.length;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArrayValue other = (ByteArrayValue)obj;
        return Arrays.equals(this.value, other.value);
    }

    @Override
    public DataType getType() {
        return DataType.BYTE_ARRAY;
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    public String toString() {
        return "ByteArrayValue [value=" + Arrays.toString(this.value) + "]";
    }
}

