/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.security.tamper.detection;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.kura.security.tamper.detection.TamperStatus;
import org.osgi.service.event.Event;

public class TamperEvent
extends Event {
    public static final String TAMPER_EVENT_TOPIC = "org/eclipse/kura/security/tamper/detection/TamperEvent/TAMPER_STATUS_CHANGED";
    public static final String TAMPER_STATUS_PROPERTY_KEY = "tamper.status";
    public static final String SENDER_PID_PROPERTY_KEY = "sender.pid";

    public TamperEvent(String tamperDetectionServicePid, TamperStatus tamperStatus) {
        super(TAMPER_EVENT_TOPIC, TamperEvent.buildEventProperties(tamperDetectionServicePid, tamperStatus));
    }

    public TamperStatus getTamperStatus() {
        return (TamperStatus)this.getProperty(TAMPER_STATUS_PROPERTY_KEY);
    }

    public String getSenderPid() {
        return (String)this.getProperty(SENDER_PID_PROPERTY_KEY);
    }

    private static Map<String, Object> buildEventProperties(String tamperDetectionServicePid, TamperStatus tamperStatus) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(TAMPER_STATUS_PROPERTY_KEY, Objects.requireNonNull(tamperStatus, "Tamper status cannot be null"));
        properties.put(SENDER_PID_PROPERTY_KEY, Objects.requireNonNull(tamperDetectionServicePid, "Tamper detection service pid cannot be null"));
        return properties;
    }
}

