/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.net.firewall;

import java.net.UnknownHostException;
import java.util.Objects;
import org.eclipse.kura.net.IPAddress;
import org.eclipse.kura.net.NetProtocol;
import org.eclipse.kura.net.NetworkPair;
import org.eclipse.kura.net.firewall.FirewallOpenPortConfig;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public abstract class FirewallOpenPortConfigIP<T extends IPAddress>
implements FirewallOpenPortConfig {
    private int port;
    private String portRange;
    private NetProtocol protocol;
    private NetworkPair<T> permittedNetwork;
    private String permittedInterfaceName;
    private String unpermittedInterfaceName;
    private String permittedMac;
    private String sourcePortRange;

    @Deprecated
    public FirewallOpenPortConfigIP() {
    }

    @Deprecated
    public FirewallOpenPortConfigIP(int port, NetProtocol protocol, NetworkPair<T> permittedNetwork, String permittedInterfaceName, String unpermittedInterfaceName, String permittedMac, String sourcePortRange) {
        this.port = port;
        this.portRange = null;
        this.protocol = protocol;
        this.permittedNetwork = permittedNetwork;
        this.permittedInterfaceName = permittedInterfaceName;
        this.unpermittedInterfaceName = unpermittedInterfaceName;
        this.permittedMac = permittedMac;
        this.sourcePortRange = sourcePortRange;
    }

    @Deprecated
    public FirewallOpenPortConfigIP(String portRange, NetProtocol protocol, NetworkPair<T> permittedNetwork, String permittedInterfaceName, String unpermittedInterfaceName, String permittedMac, String sourcePortRange) {
        this.portRange = portRange;
        this.port = -1;
        this.protocol = protocol;
        this.permittedNetwork = permittedNetwork;
        this.permittedInterfaceName = permittedInterfaceName;
        this.unpermittedInterfaceName = unpermittedInterfaceName;
        this.permittedMac = permittedMac;
        this.sourcePortRange = sourcePortRange;
    }

    protected FirewallOpenPortConfigIP(FirewallOpenPortConfigIPBuilder<T, ?> builder) {
        this.portRange = builder.portRange;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.permittedNetwork = builder.permittedNetwork;
        this.permittedInterfaceName = builder.permittedInterfaceName;
        this.unpermittedInterfaceName = builder.unpermittedInterfaceName;
        this.permittedMac = builder.permittedMac;
        this.sourcePortRange = builder.sourcePortRange;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Deprecated
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getPortRange() {
        return this.portRange;
    }

    @Deprecated
    public void setPortRange(String portRange) {
        this.portRange = portRange;
    }

    @Override
    public NetProtocol getProtocol() {
        return this.protocol;
    }

    @Deprecated
    public void setProtocol(NetProtocol protocol) {
        this.protocol = protocol;
    }

    public NetworkPair<T> getPermittedNetwork() {
        return this.permittedNetwork;
    }

    @Override
    public String getPermittedNetworkString() {
        return String.valueOf(((IPAddress)this.permittedNetwork.getIpAddress()).getHostAddress()) + "/" + this.permittedNetwork.getPrefix();
    }

    @Deprecated
    public void setPermittedNetwork(NetworkPair<T> permittedNetwork) {
        this.permittedNetwork = permittedNetwork;
    }

    public String getPermittedInterfaceName() {
        return this.permittedInterfaceName;
    }

    @Deprecated
    public void setPermittedInterfaceName(String permittedInterfaceName) {
        this.permittedInterfaceName = permittedInterfaceName;
    }

    public String getUnpermittedInterfaceName() {
        return this.unpermittedInterfaceName;
    }

    @Deprecated
    public void setUnpermittedInterfaceName(String unpermittedInterfaceName) {
        this.unpermittedInterfaceName = unpermittedInterfaceName;
    }

    @Override
    public String getPermittedMac() {
        return this.permittedMac;
    }

    @Deprecated
    public void setPermittedMac(String permittedMac) {
        this.permittedMac = permittedMac;
    }

    @Override
    public String getSourcePortRange() {
        return this.sourcePortRange;
    }

    @Deprecated
    public void setSourcePortRange(String sourcePortRange) {
        this.sourcePortRange = sourcePortRange;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.permittedInterfaceName, this.permittedMac, this.permittedNetwork, this.port, this.portRange, this.protocol, this.sourcePortRange, this.unpermittedInterfaceName});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FirewallOpenPortConfigIP other = (FirewallOpenPortConfigIP)obj;
        return Objects.equals(this.permittedInterfaceName, other.permittedInterfaceName) && Objects.equals(this.permittedMac, other.permittedMac) && Objects.equals(this.permittedNetwork, other.permittedNetwork) && this.port == other.port && Objects.equals(this.portRange, other.portRange) && this.protocol == other.protocol && Objects.equals(this.sourcePortRange, other.sourcePortRange) && Objects.equals(this.unpermittedInterfaceName, other.unpermittedInterfaceName);
    }

    @Override
    public boolean isValid() {
        if (this.port < 0 || this.port > 65535) {
            return false;
        }
        return this.protocol != null && this.protocol.equals((Object)NetProtocol.tcp) && this.protocol.equals((Object)NetProtocol.udp);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FirewallOpenPortConfigIP [port=");
        builder.append(this.port);
        builder.append(", portRange=");
        builder.append(this.portRange);
        builder.append(", protocol=");
        builder.append((Object)this.protocol);
        builder.append(", permittedNetwork=");
        builder.append(this.permittedNetwork);
        builder.append(", permittedMac=");
        builder.append(this.permittedMac);
        builder.append(", sourcePortRange=");
        builder.append(this.sourcePortRange);
        builder.append("]");
        return builder.toString();
    }

    @ProviderType
    public static abstract class FirewallOpenPortConfigIPBuilder<U extends IPAddress, T extends FirewallOpenPortConfigIPBuilder<U, T>> {
        protected int port = -1;
        protected String portRange;
        protected NetProtocol protocol;
        protected NetworkPair<U> permittedNetwork;
        protected String permittedInterfaceName;
        protected String unpermittedInterfaceName;
        protected String permittedMac;
        protected String sourcePortRange;

        public T withPort(int port) {
            this.port = port;
            return this.getThis();
        }

        public T withPortRange(String portRange) {
            this.portRange = portRange;
            return this.getThis();
        }

        public T withProtocol(NetProtocol protocol) {
            this.protocol = protocol;
            return this.getThis();
        }

        public T withPermittedNetwork(NetworkPair<U> permittedNetwork) {
            this.permittedNetwork = permittedNetwork;
            return this.getThis();
        }

        public T withPermittedInterfaceName(String permittedInterfaceName) {
            this.permittedInterfaceName = permittedInterfaceName;
            return this.getThis();
        }

        public T withUnpermittedInterfaceName(String unpermittedInterfaceName) {
            this.unpermittedInterfaceName = unpermittedInterfaceName;
            return this.getThis();
        }

        public T withPermittedMac(String permittedMac) {
            this.permittedMac = permittedMac;
            return this.getThis();
        }

        public T withSourcePortRange(String sourcePortRange) {
            this.sourcePortRange = sourcePortRange;
            return this.getThis();
        }

        public abstract T getThis();

        public abstract FirewallOpenPortConfigIP<U> build() throws UnknownHostException;
    }
}

