/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.message.store;

import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.kura.data.DataTransportToken;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class StoredMessage {
    private final int id;
    private final String topic;
    private final int qos;
    private final boolean retain;
    private final int priority;
    private final byte[] payload;
    private final Optional<Date> createdOn;
    private final Optional<Date> publishedOn;
    private final Optional<Date> confirmedOn;
    private final Optional<Date> droppedOn;
    private final Optional<DataTransportToken> dataTransportToken;

    private StoredMessage(Builder b) {
        this.id = b.id;
        this.topic = b.topic;
        this.qos = b.qos;
        this.retain = b.retain;
        this.priority = b.priority;
        this.payload = b.payload;
        this.createdOn = Optional.ofNullable(b.createdOn);
        this.publishedOn = Optional.ofNullable(b.publishedOn);
        this.confirmedOn = Optional.ofNullable(b.confirmedOn);
        this.dataTransportToken = Optional.ofNullable(b.dataTransportToken);
        this.droppedOn = Optional.ofNullable(b.droppedOn);
    }

    public int getId() {
        return this.id;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getQos() {
        return this.qos;
    }

    public boolean isRetain() {
        return this.retain;
    }

    public int getPriority() {
        return this.priority;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public Optional<Date> getCreatedOn() {
        return this.createdOn;
    }

    public Optional<Date> getPublishedOn() {
        return this.publishedOn;
    }

    public Optional<Date> getConfirmedOn() {
        return this.confirmedOn;
    }

    public Optional<Date> getDroppedOn() {
        return this.droppedOn;
    }

    public Optional<DataTransportToken> getDataTransportToken() {
        return this.dataTransportToken;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.payload);
        result = 31 * result + Objects.hash(this.confirmedOn, this.createdOn, this.dataTransportToken, this.droppedOn, this.id, this.priority, this.publishedOn, this.qos, this.retain, this.topic);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StoredMessage)) {
            return false;
        }
        StoredMessage other = (StoredMessage)obj;
        return Objects.equals(this.confirmedOn, other.confirmedOn) && Objects.equals(this.createdOn, other.createdOn) && Objects.equals(this.dataTransportToken, other.dataTransportToken) && Objects.equals(this.droppedOn, other.droppedOn) && this.id == other.id && Arrays.equals(this.payload, other.payload) && this.priority == other.priority && Objects.equals(this.publishedOn, other.publishedOn) && this.qos == other.qos && this.retain == other.retain && Objects.equals(this.topic, other.topic);
    }

    public String toString() {
        return "StoredMessage [id=" + this.id + ", topic=" + this.topic + ", qos=" + this.qos + ", retain=" + this.retain + ", priority=" + this.priority + ", payload=" + Arrays.toString(this.payload) + ", createdOn=" + this.createdOn + ", publishedOn=" + this.publishedOn + ", confirmedOn=" + this.confirmedOn + ", droppedOn=" + this.droppedOn + ", dataTransportToken=" + this.dataTransportToken + "]";
    }

    /* synthetic */ StoredMessage(Builder builder, StoredMessage storedMessage) {
        this(builder);
    }

    @ProviderType
    public static class Builder {
        private final int id;
        private String topic;
        private int qos;
        private boolean retain;
        private byte[] payload;
        private int priority;
        private Date createdOn;
        private Date publishedOn;
        private Date confirmedOn;
        private Date droppedOn;
        private DataTransportToken dataTransportToken;

        public Builder(int id) {
            this.id = id;
        }

        public Builder withTopic(String topic) {
            this.topic = topic;
            return this;
        }

        public Builder withQos(int qos) {
            this.qos = qos;
            return this;
        }

        public Builder withRetain(boolean retain) {
            this.retain = retain;
            return this;
        }

        public Builder withCreatedOn(Date createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public Builder withPublishedOn(Date publishedOn) {
            this.publishedOn = publishedOn;
            return this;
        }

        public Builder withConfirmedOn(Date confirmedOn) {
            this.confirmedOn = confirmedOn;
            return this;
        }

        public Builder withPayload(byte[] payload) {
            this.payload = payload;
            return this;
        }

        public Builder withPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder withDataTransportToken(DataTransportToken token) {
            this.dataTransportToken = token;
            return this;
        }

        public Builder withDroppedOn(Date droppedOn) {
            this.droppedOn = droppedOn;
            return this;
        }

        public StoredMessage build() {
            return new StoredMessage(this, null);
        }
    }
}

