/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.auth;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationAdminHelper {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationAdminHelper.class);

    private ConfigurationAdminHelper() {
    }

    public static Map<String, Object> loadConfigurationProperties(ConfigurationAdmin configurationAdmin, String pid) {
        return ConfigurationAdminHelper.getConfiguration(configurationAdmin, pid).map(Configuration::getProperties).map(ConfigurationAdminHelper::dictionaryToMap).orElseGet(() -> new HashMap());
    }

    public static Map<String, Object> loadConsoleConfigurationProperties(ConfigurationAdmin configurationAdmin) {
        return ConfigurationAdminHelper.loadConfigurationProperties(configurationAdmin, "org.eclipse.kura.web.Console");
    }

    public static Map<String, Object> loadHttpServiceConfigurationProperties(ConfigurationAdmin configurationAdmin) {
        return ConfigurationAdminHelper.loadConfigurationProperties(configurationAdmin, "org.eclipse.kura.http.server.manager.HttpService");
    }

    public static Optional<String> getLoginMessage(Map<String, Object> properties) {
        Object messageEnabled = properties.get("access.banner.enabled");
        Object message = properties.get("access.banner.content");
        if (!Boolean.TRUE.equals(messageEnabled)) {
            return Optional.empty();
        }
        if (!(message instanceof String)) {
            return Optional.empty();
        }
        return Optional.of((String)message);
    }

    public static Set<Integer> getHttpsMutualAuthPorts(Map<String, Object> properties) {
        Object rawPortList = properties.get("https.client.auth.ports");
        if (!(rawPortList instanceof Integer[])) {
            return Collections.emptySet();
        }
        Integer[] portList = (Integer[])rawPortList;
        return Arrays.stream(portList).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static Optional<Configuration> getConfiguration(ConfigurationAdmin configurationAdmin, String pid) {
        try {
            return Optional.ofNullable(configurationAdmin.getConfiguration(pid, "?"));
        }
        catch (IOException e) {
            logger.warn("Failed to retrieve configuration for {}", (Object)pid, (Object)e);
            return Optional.empty();
        }
    }

    private static final Map<String, Object> dictionaryToMap(Dictionary<String, Object> dict) {
        HashMap<String, Object> result = new HashMap<String, Object>(dict.size());
        Enumeration<String> keys = dict.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            result.put(key, dict.get(key));
        }
        return result;
    }
}

