/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.rest.command.api;

import java.util.Base64;
import java.util.Map;

public class RestCommandRequest {
    private String command;
    private String password;
    private String zipBytes;
    private String[] arguments;
    private Map<String, String> environmentPairs;
    private String workingDirectory;

    public void setCommand(String command) {
        this.command = command;
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public void setEnvironmentPairs(Map<String, String> environmentPairs) {
        this.environmentPairs = environmentPairs;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setZipBytes(String zipBytes) {
        this.zipBytes = zipBytes;
    }

    public String getCommand() {
        return this.command;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public Map<String, String> getEnvironmentPairs() {
        return this.environmentPairs;
    }

    public String[] getEnvironmentPairsAsStringArray() {
        if (this.environmentPairs == null) {
            return new String[0];
        }
        return (String[])this.environmentPairs.entrySet().stream().map(entry -> String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue()).toArray(String[]::new);
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public String getPassword() {
        return this.password;
    }

    public String getZipBytes() {
        return this.zipBytes;
    }

    public byte[] getZipBytesAsByteArray() {
        if (this.zipBytes == null) {
            return new byte[0];
        }
        return Base64.getDecoder().decode(this.zipBytes);
    }
}

