/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.cloudconnection.provider;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.kura.cloudconnection.request.RequestHandler;
import org.eclipse.kura.cloudconnection.request.RequestHandlerRegistry;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.internal.rest.cloudconnection.provider.CloudConnectionManagerBridge;
import org.eclipse.kura.internal.rest.cloudconnection.provider.CloudConnectionService;
import org.eclipse.kura.internal.rest.cloudconnection.provider.dto.CloudComponentFactories;
import org.eclipse.kura.internal.rest.cloudconnection.provider.dto.CloudComponentInstances;
import org.eclipse.kura.internal.rest.cloudconnection.provider.dto.CloudConnectionFactoryPidAndCloudEndpointPid;
import org.eclipse.kura.internal.rest.cloudconnection.provider.dto.CloudEndpointPidRequest;
import org.eclipse.kura.internal.rest.cloudconnection.provider.dto.ConnectedStatus;
import org.eclipse.kura.internal.rest.cloudconnection.provider.dto.PidAndFactoryPidAndCloudEndpointPid;
import org.eclipse.kura.request.handler.jaxrs.DefaultExceptionHandler;
import org.eclipse.kura.request.handler.jaxrs.JaxRsRequestHandlerProxy;
import org.eclipse.kura.rest.configuration.api.ComponentConfigurationList;
import org.eclipse.kura.rest.configuration.api.DTOUtil;
import org.eclipse.kura.rest.configuration.api.PidAndFactoryPid;
import org.eclipse.kura.rest.configuration.api.PidSet;
import org.eclipse.kura.rest.configuration.api.UpdateComponentConfigurationRequest;
import org.osgi.service.useradmin.UserAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="cloudconnection/v1")
public class CloudConnectionRestService {
    private static final Logger logger = LoggerFactory.getLogger(CloudConnectionRestService.class);
    private static final String MQTT_APP_ID = "CLD-V1";
    private static final String REST_ROLE_NAME = "cloudconnection";
    private static final String KURA_PERMISSION_REST_ROLE = "kura.permission.rest.cloudconnection";
    private final RequestHandler requestHandler = new JaxRsRequestHandlerProxy((Object)this);
    private CloudConnectionService cloudConnectionService;
    private CloudConnectionManagerBridge cloudConnectionManagerBridge;
    private ConfigurationService configurationService;
    private CryptoService cryptoService;

    public void bindUserAdmin(UserAdmin userAdmin) {
        userAdmin.createRole(KURA_PERMISSION_REST_ROLE, 2);
    }

    public void bindCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    public void bindRequestHandlerRegistry(RequestHandlerRegistry registry) {
        try {
            registry.registerRequestHandler(MQTT_APP_ID, this.requestHandler);
        }
        catch (Exception e) {
            logger.warn("Failed to register {} request handler", (Object)MQTT_APP_ID, (Object)e);
        }
    }

    public void bindConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void unbindRequestHandlerRegistry(RequestHandlerRegistry registry) {
        try {
            registry.unregister(MQTT_APP_ID);
        }
        catch (Exception e) {
            logger.warn("Failed to unregister {} request handler", (Object)MQTT_APP_ID, (Object)e);
        }
    }

    public void activate() {
        this.cloudConnectionService = new CloudConnectionService(this.configurationService);
        this.cloudConnectionManagerBridge = new CloudConnectionManagerBridge();
    }

    @GET
    @RolesAllowed(value={"cloudconnection"})
    @Path(value="/instances")
    @Produces(value={"application/json"})
    public CloudComponentInstances findCloudComponentInstances() {
        try {
            return new CloudComponentInstances(this.cloudConnectionService.findCloudEndpointInstances(), this.cloudConnectionService.findPubsubInstances());
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
    }

    @POST
    @RolesAllowed(value={"cloudconnection"})
    @Path(value="/cloudEndpoint/stackComponentPids")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public PidSet getStackComponentsPids(CloudConnectionFactoryPidAndCloudEndpointPid cloudConnectionFactoryPidAndCloudEndpointPid) {
        try {
            Set<String> pidSet = this.cloudConnectionService.getStackComponentsPids(cloudConnectionFactoryPidAndCloudEndpointPid.getCloudConnectionFactoryPid(), cloudConnectionFactoryPidAndCloudEndpointPid.getCloudEndpointPid());
            return new PidSet(pidSet);
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
    }

    @POST
    @RolesAllowed(value={"cloudconnection"})
    @Path(value="/cloudEndpoint")
    @Consumes(value={"application/json"})
    public Response createCloudEndpoint(CloudConnectionFactoryPidAndCloudEndpointPid cloudConnectionFactoryPidAndCloudEndpointPid) {
        try {
            this.cloudConnectionService.createCloudEndpointFromFactory(cloudConnectionFactoryPidAndCloudEndpointPid.getCloudConnectionFactoryPid(), cloudConnectionFactoryPidAndCloudEndpointPid.getCloudEndpointPid());
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
        return Response.ok().build();
    }

    @DELETE
    @RolesAllowed(value={"cloudconnection"})
    @Path(value="/cloudEndpoint")
    @Consumes(value={"application/json"})
    public Response deleteCloudEndpoint(CloudConnectionFactoryPidAndCloudEndpointPid cloudConnectionFactoryPidAndCloudEndpointPid) {
        try {
            this.cloudConnectionService.deleteCloudEndpointFromFactory(cloudConnectionFactoryPidAndCloudEndpointPid.getCloudConnectionFactoryPid(), cloudConnectionFactoryPidAndCloudEndpointPid.getCloudEndpointPid());
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
        return Response.ok().build();
    }

    @GET
    @RolesAllowed(value={"cloudconnection"})
    @Path(value="/factories")
    @Produces(value={"application/json"})
    public CloudComponentFactories getCloudComponentFactories() {
        try {
            return this.cloudConnectionService.getCloudComponentFactories();
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
    }

    @POST
    @RolesAllowed(value={"cloudconnection"})
    @Path(value="/pubSub")
    @Consumes(value={"application/json"})
    public Response createPubSubInstance(PidAndFactoryPidAndCloudEndpointPid pidAndFactoryPidAndCloudEndpointPid) {
        try {
            this.cloudConnectionService.createPubSubInstance(pidAndFactoryPidAndCloudEndpointPid.getPid(), pidAndFactoryPidAndCloudEndpointPid.getFactoryPid(), pidAndFactoryPidAndCloudEndpointPid.getCloudEndpointPid());
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
        return Response.ok().build();
    }

    @DELETE
    @RolesAllowed(value={"cloudconnection"})
    @Path(value="/pubSub")
    @Consumes(value={"application/json"})
    public Response deletePubSubInstance(PidAndFactoryPid pidAndFactoryPid) {
        try {
            this.cloudConnectionService.deletePubSubInstance(pidAndFactoryPid.getPid());
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
        return Response.ok().build();
    }

    @POST
    @RolesAllowed(value={"cloudconnection"})
    @Path(value="/configurations")
    @Consumes(value={"application/json"})
    public ComponentConfigurationList getConfigurations(PidSet pidSet) {
        try {
            List<ComponentConfiguration> result = this.cloudConnectionService.getPubSubConfiguration(pidSet.getPids());
            result.addAll(this.cloudConnectionService.getStackConfigurationsByPid(pidSet.getPids()));
            return new ComponentConfigurationList(result.stream().map(c -> DTOUtil.toComponentConfigurationDTO((ComponentConfiguration)c, (CryptoService)this.cryptoService, (boolean)false).replacePasswordsWithPlaceholder()).collect(Collectors.toList()));
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
    }

    @PUT
    @RolesAllowed(value={"cloudconnection"})
    @Path(value="/configurations")
    @Consumes(value={"application/json"})
    public Response updateStackComponentConfigurations(UpdateComponentConfigurationRequest updateComponentConfigurationRequest) {
        try {
            this.cloudConnectionService.updateStackComponentConfiguration(updateComponentConfigurationRequest.getComponentConfigurations(), updateComponentConfigurationRequest.isTakeSnapshot());
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
        return Response.ok().build();
    }

    @POST
    @RolesAllowed(value={"cloudconnection"})
    @Path(value="/cloudEndpoint/connect")
    @Consumes(value={"application/json"})
    public Response connectCloudEndpoint(CloudEndpointPidRequest cloudEndpointPid) {
        try {
            this.cloudConnectionManagerBridge.connectCloudEndpoint(cloudEndpointPid.getCloudEndpointPid());
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
        return Response.ok().build();
    }

    @POST
    @RolesAllowed(value={"cloudconnection"})
    @Path(value="/cloudEndpoint/disconnect")
    @Consumes(value={"application/json"})
    public Response disconnectCloudEndpoint(CloudEndpointPidRequest cloudEndpointPid) {
        try {
            this.cloudConnectionManagerBridge.disconnectCloudEndpoint(cloudEndpointPid.getCloudEndpointPid());
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
        return Response.ok().build();
    }

    @POST
    @RolesAllowed(value={"cloudconnection"})
    @Path(value="/cloudEndpoint/isConnected")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ConnectedStatus isConnectedCloudEndpoint(CloudEndpointPidRequest cloudEndpointPid) {
        try {
            return new ConnectedStatus(this.cloudConnectionManagerBridge.isConnectedCloudEndpoint(cloudEndpointPid.getCloudEndpointPid()));
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
    }
}

