/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.linux.bluetooth.le.beacon;

@Deprecated
public class BluetoothAdvertisingData {
    private static final String PKT_BYTES_NUMBER = "1e";
    private static final String AD_BYTES_NUMBER = "02";
    private static final String AD_FLAG = "01";
    private static final String PAYLOAD_BYTES_NUMBER = "1a";
    private static final String MANUFACTURER_AD = "ff";
    private static final String BEACON_ID = "0215";
    private static final int MAJOR_MAX = 65535;
    private static final int MAJOR_MIN = 0;
    private static final int MINOR_MAX = 65535;
    private static final int MINOR_MIN = 0;
    private static final short TX_POWER_MAX = 126;
    private static final short TX_POWER_MIN = -127;
    private static final String UUID_DEFAULT = "aaaaaaaabbbbccccddddeeeeeeeeeeee";

    private BluetoothAdvertisingData() {
    }

    public static String getData(String uuid, Integer major, Integer minor, String companyCode, Integer txPower, boolean leLimited, boolean leGeneral, boolean brEDRSupported, boolean leBRController, boolean leBRHost) {
        String txPowerString;
        String data = "";
        String flags = "000";
        flags = String.valueOf(flags) + Integer.toString(leBRHost ? 1 : 0);
        flags = String.valueOf(flags) + Integer.toString(leBRController ? 1 : 0);
        flags = String.valueOf(flags) + Integer.toString(brEDRSupported ? 1 : 0);
        flags = String.valueOf(flags) + Integer.toString(leGeneral ? 1 : 0);
        String flagsString = Integer.toHexString(Integer.parseInt(flags = String.valueOf(flags) + Integer.toString(leLimited ? 1 : 0), 2));
        if (flagsString.length() == 1) {
            flagsString = "0" + flagsString;
        }
        if ((txPowerString = Integer.toHexString((txPower = Integer.valueOf(BluetoothAdvertisingData.inSetRange(txPower, 126, -127))) & 0xFF)).length() == 1) {
            txPowerString = "0" + txPowerString;
        }
        data = String.valueOf(data) + PKT_BYTES_NUMBER;
        data = String.valueOf(data) + AD_BYTES_NUMBER;
        data = String.valueOf(data) + AD_FLAG;
        data = String.valueOf(data) + flagsString;
        data = String.valueOf(data) + PAYLOAD_BYTES_NUMBER;
        data = String.valueOf(data) + MANUFACTURER_AD;
        data = String.valueOf(data) + companyCode.substring(2, 4);
        data = String.valueOf(data) + companyCode.substring(0, 2);
        data = String.valueOf(data) + BEACON_ID;
        data = uuid.length() == 32 ? String.valueOf(data) + BluetoothAdvertisingData.inSetHex(uuid, UUID_DEFAULT) : String.valueOf(data) + UUID_DEFAULT;
        data = String.valueOf(data) + BluetoothAdvertisingData.to2BytesHex(BluetoothAdvertisingData.inSetRange(major, 65535, 0));
        data = String.valueOf(data) + BluetoothAdvertisingData.to2BytesHex(BluetoothAdvertisingData.inSetRange(minor, 65535, 0));
        data = String.valueOf(data) + txPowerString;
        data = String.valueOf(data) + "00";
        return data;
    }

    private static String inSetHex(String uuid, String defaultUuid) {
        if (!uuid.matches("^[0-9a-fA-F]+$")) {
            return defaultUuid;
        }
        return uuid;
    }

    private static int inSetRange(int value, int max, int min) {
        if (value <= max && value >= min) {
            return value;
        }
        return value > max ? max : min;
    }

    public static String to2BytesHex(Integer in) {
        String out = Integer.toHexString(in);
        if (out.length() == 1) {
            out = "000" + out;
        } else if (out.length() == 2) {
            out = "00" + out;
        } else if (out.length() == 3) {
            out = "0" + out;
        } else if (out.length() > 4) {
            out = out.substring(out.length() - 4);
        }
        return out;
    }
}

