/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.wire.camel;

import java.util.Map;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.wire.WireComponent;
import org.eclipse.kura.wire.WireEnvelope;
import org.eclipse.kura.wire.WireHelperService;
import org.eclipse.kura.wire.WireSupport;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.wireadmin.Wire;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWireComponent
implements WireComponent,
ConfigurableComponent {
    private static final Logger logger = LoggerFactory.getLogger(AbstractWireComponent.class);
    private WireHelperService wireHelperService;
    protected WireSupport wireSupport;

    public void setWireHelperService(WireHelperService wireHelperService) {
        this.wireHelperService = wireHelperService;
    }

    protected synchronized void activate(ComponentContext componentContext, Map<String, ?> properties) throws Exception {
        if (this.wireSupport == null) {
            this.wireSupport = this.wireHelperService.newWireSupport((WireComponent)this, componentContext.getServiceReference());
        }
    }

    protected void modified(ComponentContext componentContext, Map<String, ?> properties) throws Exception {
    }

    protected synchronized void deactivate() {
    }

    public synchronized void updated(Wire wire, Object value) {
        logger.debug("Updated: {}", (Object)wire);
        this.wireSupport.updated(wire, value);
    }

    public synchronized void producersConnected(Wire[] wires) {
        logger.info("Producers connected - {}", (Object)wires);
        this.wireSupport.producersConnected(wires);
    }

    public synchronized Object polled(Wire wire) {
        logger.debug("Polled: {}", (Object)wire);
        return this.wireSupport.polled(wire);
    }

    public synchronized void consumersConnected(Wire[] wires) {
        logger.info("Consumers connected - {}", (Object)wires);
        this.wireSupport.consumersConnected(wires);
    }

    public synchronized void onWireReceive(WireEnvelope wireEnvelope) {
        logger.debug("onWireReceive: {}", (Object)wireEnvelope);
    }
}

