/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.util.Set;
import org.eclipse.kura.configuration.ConfigurableComponent;
import org.eclipse.kura.web.Console;
import org.eclipse.kura.web.ConsoleOptions;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.server.util.GwtServerUtil;
import org.eclipse.kura.web.shared.model.GwtLoginInfo;
import org.eclipse.kura.web.shared.service.GwtLoginInfoService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwtLoginInfoServiceImpl
extends OsgiRemoteServiceServlet
implements GwtLoginInfoService {
    private static final Logger logger = LoggerFactory.getLogger(GwtLoginInfoServiceImpl.class);
    private static final long serialVersionUID = 1L;

    @Override
    public GwtLoginInfo getLoginInfo() {
        ConsoleOptions options = Console.getConsoleOptions();
        String bannerContent = options.isBannerEnabled() ? options.getBannerContent() : null;
        Integer clientAuthPort = null;
        try {
            BundleContext bundleContext = FrameworkUtil.getBundle(GwtLoginInfoServiceImpl.class).getBundleContext();
            ServiceReference ref = bundleContext.getServiceReferences(ConfigurableComponent.class.getName(), "(service.pid=org.eclipse.kura.http.server.manager.HttpService)")[0];
            Set<Integer> clientAuthPorts = GwtServerUtil.getArrayProperty(ref.getProperty("https.client.auth.ports"), Integer.class);
            for (Integer port : clientAuthPorts) {
                if (!Console.getConsoleOptions().isPortAllowed(port)) continue;
                clientAuthPort = port;
                break;
            }
        }
        catch (Exception e) {
            logger.warn("failed to determine HTTP cert auth port", (Throwable)e);
            clientAuthPort = null;
        }
        return new GwtLoginInfo(bannerContent, options.getEnabledAuthMethods(), clientAuthPort);
    }
}

