/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web;

import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.util.useradmin.UserAdminHelper;
import org.eclipse.kura.web.ConsoleOptions;
import org.eclipse.kura.web.shared.KuraPermission;
import org.eclipse.kura.web.shared.model.GwtUserConfig;
import org.eclipse.kura.web.shared.model.GwtUserData;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.useradmin.Role;
import org.osgi.service.useradmin.User;
import org.osgi.service.useradmin.UserAdmin;

public class UserManager {
    private static final String PERMISSION_ROLE_NAME_PREFIX = "kura.permission.";
    private static final String USER_ROLE_NAME_PREFIX = "kura.user.";
    private static final String PASSWORD_PROPERTY = "kura.password";
    private static final String KURA_NEED_PASSWORD_CHANGE = "kura.need.password.change";
    private final CryptoService cryptoService;
    private final UserAdminHelper userAdminHelper;

    public UserManager(UserAdmin userAdmin, CryptoService cryptoService) {
        this.cryptoService = cryptoService;
        this.userAdminHelper = new UserAdminHelper(userAdmin, cryptoService);
    }

    public void update(ConsoleOptions consoleOptions) throws NoSuchAlgorithmException, UnsupportedEncodingException, KuraException, InvalidSyntaxException {
        this.initializeUserAdmin(consoleOptions);
    }

    public void authenticateWithPassword(String username, String password) throws KuraException {
        try {
            this.userAdminHelper.verifyUsernamePassword(username, password);
        }
        catch (UserAdminHelper.AuthenticationException e) {
            throw new KuraException(KuraErrorCode.SECURITY_EXCEPTION, (Throwable)e, new Object[0]);
        }
    }

    public void requirePermissions(String username, String ... permissions) throws KuraException {
        try {
            this.userAdminHelper.requirePermissions(username, permissions);
        }
        catch (UserAdminHelper.AuthenticationException e) {
            throw new KuraException(KuraErrorCode.SECURITY_EXCEPTION, (Throwable)e, new Object[0]);
        }
    }

    public boolean isPasswordChangeRequired(String username) {
        return this.userAdminHelper.isPasswordChangeRequired(username);
    }

    public void createUser(String userName) {
        this.userAdminHelper.createUser(userName);
    }

    public void deleteUser(String userName) {
        this.userAdminHelper.deleteUser(userName);
    }

    public boolean setUserPassword(String userName, String userPassword) throws KuraException {
        try {
            this.userAdminHelper.changeUserPassword(userName, userPassword);
            return true;
        }
        catch (UserAdminHelper.AuthenticationException e) {
            if (e.getReason() == UserAdminHelper.AuthenticationException.Reason.PASSWORD_CHANGE_WITH_SAME_PASSWORD) {
                return false;
            }
            throw new KuraException(KuraErrorCode.SECURITY_EXCEPTION);
        }
    }

    public Set<String> getDefinedPermissions() {
        return this.userAdminHelper.getDefinedPermissions();
    }

    public Set<GwtUserConfig> getUserConfig() {
        HashMap result = new HashMap();
        this.userAdminHelper.foreachUser((name, user) -> {
            GwtUserConfig userData = this.initUserConfig(user);
            result.put(user.getName(), userData);
        });
        this.fillPermissions(result);
        return new HashSet<GwtUserConfig>(result.values());
    }

    public Optional<GwtUserConfig> getUserConfig(String userName) {
        Optional user = this.userAdminHelper.getUser(userName);
        if (!user.isPresent()) {
            return Optional.empty();
        }
        GwtUserConfig userConfig = this.initUserConfig((User)user.get());
        this.fillPermissions(Collections.singletonMap(((User)user.get()).getName(), userConfig));
        return Optional.of(userConfig);
    }

    public Optional<Integer> getCredentialsHash(String userName) {
        return this.userAdminHelper.getCredentialsHash(userName);
    }

    public void setUserConfig(Set<GwtUserConfig> userData) throws KuraException {
        this.userAdminHelper.foreachUser((name, user) -> {
            if (userData.stream().noneMatch(data -> data.getUserName().equals(name))) {
                this.deleteUser(name);
            }
        });
        this.userAdminHelper.foreachPermission((permissionName, permissionGroup) -> {
            for (GwtUserData data : userData) {
                User user = this.userAdminHelper.getOrCreateUser(data.getUserName());
                if (data.getPermissions().contains(permissionName)) {
                    permissionGroup.addMember((Role)user);
                    continue;
                }
                permissionGroup.removeMember((Role)user);
            }
        });
        for (GwtUserConfig config : userData) {
            User user2 = this.userAdminHelper.getOrCreateUser(config.getUserName());
            Dictionary credentials = user2.getCredentials();
            if (config.isPasswordAuthEnabled()) {
                Optional<String> password = config.getNewPassword();
                if (password.isPresent()) {
                    try {
                        credentials.put(PASSWORD_PROPERTY, this.cryptoService.sha256Hash(password.get()));
                    }
                    catch (Exception e) {
                        throw new KuraException(KuraErrorCode.SERVICE_UNAVAILABLE, (Throwable)e, new Object[0]);
                    }
                }
            } else {
                credentials.remove(PASSWORD_PROPERTY);
            }
            Dictionary properties = user2.getProperties();
            if (config.isPasswordChangeNeeded()) {
                properties.put(KURA_NEED_PASSWORD_CHANGE, "true");
                continue;
            }
            properties.remove(KURA_NEED_PASSWORD_CHANGE);
        }
    }

    private GwtUserConfig initUserConfig(User user) {
        boolean isPasswordEnabled = user.getCredentials().get(PASSWORD_PROPERTY) instanceof String;
        boolean isPasswordChangeRequired = Objects.equals("true", user.getProperties().get(KURA_NEED_PASSWORD_CHANGE));
        return new GwtUserConfig(UserManager.getBaseName((Role)user), new HashSet<String>(), isPasswordEnabled, isPasswordChangeRequired);
    }

    private void fillPermissions(Map<String, ? extends GwtUserData> userData) {
        this.userAdminHelper.foreachPermission((permission, group) -> UserManager.forEach(group.getMembers(), member -> {
            GwtUserData data = (GwtUserData)userData.get(member.getName());
            if (data != null) {
                data.getPermissions().add(permission);
            }
        }));
    }

    private static boolean isKuraUser(Role role) {
        return role.getName().startsWith(USER_ROLE_NAME_PREFIX);
    }

    private static boolean isKuraPermission(Role role) {
        return role.getName().startsWith(PERMISSION_ROLE_NAME_PREFIX);
    }

    private static String getBaseName(Role role) {
        String name = role.getName();
        if (UserManager.isKuraUser(role)) {
            return name.substring(USER_ROLE_NAME_PREFIX.length());
        }
        if (UserManager.isKuraPermission(role)) {
            return name.substring(PERMISSION_ROLE_NAME_PREFIX.length());
        }
        throw new IllegalArgumentException("not a Kura role");
    }

    private static <T, E extends Exception> void forEach(T[] items, UserAdminHelper.FallibleConsumer<T, E> consumer) throws E {
        if (items != null) {
            T[] TArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                T item = TArray[n2];
                consumer.accept(item);
                ++n2;
            }
        }
    }

    private void initializeUserAdmin(ConsoleOptions options) throws NoSuchAlgorithmException, UnsupportedEncodingException, KuraException, InvalidSyntaxException {
        for (String defaultPermission : KuraPermission.DEFAULT_PERMISSIONS) {
            this.userAdminHelper.getOrCreatePermission(defaultPermission);
        }
    }
}

