/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.data.store;

import org.eclipse.kura.KuraStoreException;
import org.eclipse.kura.core.data.store.MessageStoreState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HouseKeeperTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(HouseKeeperTask.class);
    private final int purgeAge;
    private final MessageStoreState store;

    public HouseKeeperTask(MessageStoreState store, int purgeAge) {
        this.purgeAge = purgeAge;
        this.store = store;
    }

    @Override
    public void run() {
        try {
            Thread.currentThread().setName(this.getClass().getSimpleName());
            logger.info("HouseKeeperTask started.");
            logger.info("HouseKeeperTask: Delete confirmed messages...");
            this.store.getOrOpenMessageStore().deleteStaleMessages(this.purgeAge);
            logger.info("HouseKeeperTask ended.");
        }
        catch (KuraStoreException me) {
            logger.warn("HouseCleaningTask exception", (Throwable)me);
        }
        catch (Throwable t) {
            if (t instanceof InterruptedException) {
                logger.info("HouseCleaningTask stopped");
            }
            logger.warn("HouseCleaningTask exception", t);
        }
    }
}

