/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.security.provider;

import java.util.Optional;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.eclipse.kura.cloudconnection.request.RequestHandler;
import org.eclipse.kura.cloudconnection.request.RequestHandlerRegistry;
import org.eclipse.kura.internal.rest.security.provider.dto.DebugEnabledDTO;
import org.eclipse.kura.request.handler.jaxrs.DefaultExceptionHandler;
import org.eclipse.kura.request.handler.jaxrs.JaxRsRequestHandlerProxy;
import org.eclipse.kura.security.SecurityService;
import org.osgi.service.useradmin.UserAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="security/v1")
public class SecurityRestService {
    private static final Logger logger = LoggerFactory.getLogger(SecurityRestService.class);
    private static final String DEBUG_MESSSAGE = "Processing request for method '{}'";
    private static final String MQTT_APP_ID = "SEC-V1";
    private static final String REST_ROLE_NAME = "security";
    private static final String KURA_PERMISSION_REST_ROLE = "kura.permission.rest.security";
    private SecurityService security;
    private final RequestHandler requestHandler = new JaxRsRequestHandlerProxy((Object)this);

    public void bindSecurityService(SecurityService securityService) {
        this.security = securityService;
    }

    public void bindUserAdmin(UserAdmin userAdmin) {
        userAdmin.createRole(KURA_PERMISSION_REST_ROLE, 2);
    }

    public void bindRequestHandlerRegistry(RequestHandlerRegistry registry) {
        try {
            registry.registerRequestHandler(MQTT_APP_ID, this.requestHandler);
        }
        catch (Exception e) {
            logger.warn("Failed to register {} request handler", (Object)MQTT_APP_ID, (Object)e);
        }
    }

    public void unbindRequestHandlerRegistry(RequestHandlerRegistry registry) {
        try {
            registry.unregister(MQTT_APP_ID);
        }
        catch (Exception e) {
            logger.warn("Failed to unregister {} request handler", (Object)MQTT_APP_ID, (Object)e);
        }
    }

    @POST
    @RolesAllowed(value={"security"})
    @Path(value="/security-policy-fingerprint/reload")
    @Produces(value={"application/json"})
    public Response reloadSecurityPolicyFingerprint() {
        try {
            logger.debug(DEBUG_MESSSAGE, (Object)"reloadSecurityPolicyFingerprint");
            this.security.reloadSecurityPolicyFingerprint();
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
        return Response.ok().build();
    }

    @POST
    @RolesAllowed(value={"security"})
    @Path(value="/command-line-fingerprint/reload")
    @Produces(value={"application/json"})
    public Response reloadCommandLineFingerprint() {
        try {
            logger.debug(DEBUG_MESSSAGE, (Object)"reloadCommandLineFingerprint");
            this.security.reloadCommandLineFingerprint();
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="/debug-enabled")
    @Produces(value={"application/json"})
    public DebugEnabledDTO isDebugEnabled(@Context ContainerRequestContext context) {
        try {
            if (context != null && !Optional.ofNullable(context.getSecurityContext()).filter(c -> c.getUserPrincipal() != null).isPresent()) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            logger.debug(DEBUG_MESSSAGE, (Object)"isDebugEnabled");
            return new DebugEnabledDTO(this.security.isDebugEnabled());
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
    }
}

