/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.bluetooth.wrapper;

import com.github.hypfvieh.DbusHelper;
import com.github.hypfvieh.bluetooth.wrapper.AbstractBluetoothObject;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothDeviceType;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothGattDescriptor;
import com.github.hypfvieh.bluetooth.wrapper.BluetoothGattService;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bluez.GattCharacteristic1;
import org.bluez.GattDescriptor1;
import org.bluez.exceptions.BluezFailedException;
import org.bluez.exceptions.BluezInProgressException;
import org.bluez.exceptions.BluezInvalidOffsetException;
import org.bluez.exceptions.BluezInvalidValueLengthException;
import org.bluez.exceptions.BluezNotAuthorizedException;
import org.bluez.exceptions.BluezNotPermittedException;
import org.bluez.exceptions.BluezNotSupportedException;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.interfaces.DBusInterface;

public class BluetoothGattCharacteristic
extends AbstractBluetoothObject {
    private final GattCharacteristic1 gattCharacteristic;
    private final BluetoothGattService gattService;
    private final Map<String, BluetoothGattDescriptor> descriptorByUuid = new LinkedHashMap<String, BluetoothGattDescriptor>();

    public BluetoothGattCharacteristic(GattCharacteristic1 _gattCharacteristic, BluetoothGattService _service, String _dbusPath, DBusConnection _dbusConnection) {
        super(BluetoothDeviceType.GATT_CHARACTERISTIC, _dbusConnection, _dbusPath);
        this.gattCharacteristic = _gattCharacteristic;
        this.gattService = _service;
    }

    @Override
    protected Class<? extends DBusInterface> getInterfaceClass() {
        return GattCharacteristic1.class;
    }

    public void refreshGattDescriptors() {
        this.descriptorByUuid.clear();
        Set<String> findNodes = DbusHelper.findNodes(this.getDbusConnection(), this.getDbusPath());
        Map<String, GattDescriptor1> remoteObjects = this.getRemoteObjects(findNodes, this.getDbusPath(), GattDescriptor1.class);
        for (Map.Entry<String, GattDescriptor1> entry : remoteObjects.entrySet()) {
            BluetoothGattDescriptor btDescriptor = new BluetoothGattDescriptor(entry.getValue(), this, entry.getKey(), this.getDbusConnection());
            this.descriptorByUuid.put(btDescriptor.getUuid(), btDescriptor);
        }
    }

    public List<BluetoothGattDescriptor> getGattDescriptors() {
        if (this.descriptorByUuid.isEmpty()) {
            this.refreshGattDescriptors();
        }
        return new ArrayList<BluetoothGattDescriptor>(this.descriptorByUuid.values());
    }

    public BluetoothGattDescriptor getGattDescriptorByUuid(String _uuid) {
        if (this.descriptorByUuid.isEmpty()) {
            this.refreshGattDescriptors();
        }
        return this.descriptorByUuid.get(_uuid);
    }

    public void writeValue(byte[] _value, Map<String, Object> _options) throws BluezFailedException, BluezInProgressException, BluezNotPermittedException, BluezNotAuthorizedException, BluezNotSupportedException, BluezInvalidValueLengthException {
        this.gattCharacteristic.WriteValue(_value, this.optionsToVariantMap(_options));
    }

    public byte[] readValue(Map<String, Object> _options) throws BluezFailedException, BluezInProgressException, BluezNotPermittedException, BluezNotAuthorizedException, BluezNotSupportedException, BluezInvalidOffsetException {
        return this.gattCharacteristic.ReadValue(this.optionsToVariantMap(_options));
    }

    public String getUuid() {
        return this.getTyped("UUID", String.class);
    }

    public BluetoothGattService getService() {
        return this.gattService;
    }

    public GattCharacteristic1 getRawGattCharacteristic() {
        return this.gattCharacteristic;
    }

    public byte[] getValue() {
        List typed = this.getTyped("Value", ArrayList.class);
        if (typed != null) {
            return this.byteListToByteArray(typed);
        }
        return null;
    }

    public Boolean isNotifying() {
        return this.getTyped("Notifying", Boolean.class);
    }

    public List<String> getFlags() {
        List typed = this.getTyped("Flags", ArrayList.class);
        if (typed != null) {
            return typed;
        }
        return null;
    }

    public void startNotify() throws BluezFailedException, BluezInProgressException, BluezNotSupportedException, BluezNotPermittedException {
        this.gattCharacteristic.StartNotify();
    }

    public void stopNotify() throws BluezFailedException {
        this.gattCharacteristic.StopNotify();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [gattCharacteristic=" + this.gattCharacteristic + ", gattService=" + this.gattService.getDbusPath() + ", getBluetoothType()=" + this.getBluetoothType().name() + ", getDbusPath()=" + this.getDbusPath() + "]";
    }
}

