/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.db.filter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class DbWireRecordFilterOptions {
    private static final String CONF_CACHE_EXPIRATION_INTERVAL = "cache.expiration.interval";
    private static final String CONF_SQL_VIEW = "sql.view";
    private static final String EMIT_ON_EMPTY_RESULT = "emit.on.empty.result";
    private final Map<String, Object> properties;

    public DbWireRecordFilterOptions(Map<String, Object> properties) {
        Objects.requireNonNull(properties, "Properties cannot be null");
        this.properties = Collections.unmodifiableMap(new HashMap<String, Object>(properties));
    }

    public int getCacheExpirationInterval() {
        int cacheInterval = 0;
        Object cacheInt = this.properties.get(CONF_CACHE_EXPIRATION_INTERVAL);
        if (Objects.nonNull(cacheInt) && cacheInt instanceof Integer) {
            cacheInterval = (Integer)cacheInt;
        }
        return cacheInterval;
    }

    public String getSqlView() {
        String sqlView = null;
        Object view = this.properties.get(CONF_SQL_VIEW);
        if (Objects.nonNull(view) && view instanceof String) {
            sqlView = String.valueOf(view);
        }
        return sqlView;
    }

    public boolean emitOnEmptyResult() {
        boolean result = true;
        Object emitOnEmptyResult = this.properties.get(EMIT_ON_EMPTY_RESULT);
        if (Objects.nonNull(emitOnEmptyResult) && emitOnEmptyResult instanceof Boolean) {
            result = (Boolean)emitOnEmptyResult;
        }
        return result;
    }
}

