/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.wire.db.common;

import java.io.ByteArrayInputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.internal.wire.db.common.DbServiceHelper;
import org.eclipse.kura.internal.wire.db.store.DbDataTypeMapper;
import org.eclipse.kura.type.BooleanValue;
import org.eclipse.kura.type.ByteArrayValue;
import org.eclipse.kura.type.DataType;
import org.eclipse.kura.type.DoubleValue;
import org.eclipse.kura.type.FloatValue;
import org.eclipse.kura.type.IntegerValue;
import org.eclipse.kura.type.LongValue;
import org.eclipse.kura.type.StringValue;
import org.eclipse.kura.type.TypedValue;
import org.eclipse.kura.type.TypedValues;
import org.eclipse.kura.util.collection.CollectionUtil;
import org.eclipse.kura.wire.WireRecord;

public class CommonDbServiceProvider {
    private static final Logger logger = LogManager.getLogger(CommonDbServiceProvider.class);
    protected static final String COLUMN_NAME = "COLUMN_NAME";
    protected static final String DATA_TYPE = "DATA_TYPE";
    protected static final String SQL_ADD_COLUMN = "ALTER TABLE {0} ADD COLUMN {1} {2};";
    protected static final String SQL_CREATE_TABLE_INDEX = "CREATE INDEX {0} ON {1} {2};";
    protected static final String SQL_ROW_COUNT_TABLE = "SELECT COUNT(*) FROM {0};";
    protected static final String SQL_DROP_COLUMN = "ALTER TABLE {0} DROP COLUMN {1};";
    protected static final String SQL_INSERT_RECORD = "INSERT INTO {0} ({1}) VALUES ({2});";
    protected static final String SQL_TRUNCATE_TABLE = "TRUNCATE TABLE {0};";
    protected static final String[] TABLE_TYPE = new String[]{"TABLE"};
    protected DbServiceHelper dbHelper;

    /*
     * Loose catch block
     */
    protected Integer getTableSize(String sqlTableName, Connection c, BiFunction<String, Object[], String> formatter) throws SQLException {
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            Integer n;
            ResultSet rset;
            Statement stmt;
            block16: {
                block15: {
                    stmt = c.createStatement();
                    rset = stmt.executeQuery(formatter.apply(SQL_ROW_COUNT_TABLE, new String[]{sqlTableName}));
                    rset.next();
                    n = rset.getInt(1);
                    if (rset == null) break block15;
                    rset.close();
                }
                if (stmt == null) break block16;
                stmt.close();
            }
            return n;
            {
                catch (Throwable throwable2) {
                    try {
                        if (rset != null) {
                            rset.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (stmt != null) {
                            stmt.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    protected void reconcileTable(Connection c, String tableName, String createTableQuery, BiFunction<String, Object[], String> formatter) throws SQLException {
        String sqlTableName = this.dbHelper.sanitizeSqlTableAndColumnName(tableName);
        String catalog = c.getCatalog();
        DatabaseMetaData dbMetaData = c.getMetaData();
        Throwable throwable = null;
        Object var9_10 = null;
        try (ResultSet rsTbls = dbMetaData.getTables(catalog, null, tableName, TABLE_TYPE);){
            if (!rsTbls.next()) {
                logger.info("Creating table {}...", (Object)sqlTableName);
                this.dbHelper.execute(c, formatter.apply(createTableQuery, new String[]{sqlTableName}), new Integer[0]);
                this.createIndex(c, this.dbHelper.sanitizeSqlTableAndColumnName(String.valueOf(tableName) + "_TIMESTAMP"), sqlTableName, "(TIMESTAMP DESC)", formatter);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void createIndex(Connection c, String indexname, String table, String order, BiFunction<String, Object[], String> formatter) throws SQLException {
        this.dbHelper.execute(c, formatter.apply(SQL_CREATE_TABLE_INDEX, new String[]{indexname, table, order}), new Integer[0]);
        logger.info("Index {} created, order is {}", (Object)indexname, (Object)order);
    }

    protected void reconcileColumns(Connection c, String tableName, WireRecord wireRecord, BiFunction<String, Object[], String> formatter) throws SQLException {
        Map columns = CollectionUtil.newHashMap();
        String catalog = c.getCatalog();
        DatabaseMetaData dbMetaData = c.getMetaData();
        Throwable throwable = null;
        Iterator iterator = null;
        try (ResultSet rsColumns = dbMetaData.getColumns(catalog, null, tableName, null);){
            while (rsColumns.next()) {
                String colName = rsColumns.getString(COLUMN_NAME);
                String sqlColName = this.dbHelper.sanitizeSqlTableAndColumnName(colName);
                int colType = rsColumns.getInt(DATA_TYPE);
                columns.put(sqlColName, colType);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        for (Map.Entry entry : wireRecord.getProperties().entrySet()) {
            String sqlColName = this.dbHelper.sanitizeSqlTableAndColumnName((String)entry.getKey());
            Integer sqlColType = (Integer)columns.get(sqlColName);
            DbDataTypeMapper.JdbcType jdbcType = DbDataTypeMapper.getJdbcType(((TypedValue)entry.getValue()).getType());
            String sqlTableName = this.dbHelper.sanitizeSqlTableAndColumnName(tableName);
            if (Objects.isNull(sqlColType)) {
                this.dbHelper.execute(c, formatter.apply(SQL_ADD_COLUMN, new String[]{sqlTableName, sqlColName, jdbcType.getTypeString()}), new Integer[0]);
                continue;
            }
            if (sqlColType.intValue() == jdbcType.getType()) continue;
            this.dbHelper.execute(c, formatter.apply(SQL_DROP_COLUMN, new String[]{sqlTableName, sqlColName}), new Integer[0]);
            this.dbHelper.execute(c, formatter.apply(SQL_ADD_COLUMN, new String[]{sqlTableName, sqlColName, jdbcType.getTypeString()}), new Integer[0]);
        }
    }

    protected void insertDataRecord(Connection c, String tableName, WireRecord wireRecord, BiFunction<String, Object[], String> formatter) throws SQLException {
        Map wireRecordProperties = wireRecord.getProperties();
        Throwable throwable = null;
        Object var7_8 = null;
        try (PreparedStatement stmt = this.prepareStatement(c, tableName, wireRecordProperties, new Date().getTime(), formatter);){
            stmt.execute();
            c.commit();
            logger.debug("Stored typed value");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private PreparedStatement prepareStatement(Connection connection, String tableName, Map<String, TypedValue<?>> properties, long timestamp, BiFunction<String, Object[], String> formatter) throws SQLException {
        String sqlTableName = this.dbHelper.sanitizeSqlTableAndColumnName(tableName);
        StringBuilder sbCols = new StringBuilder();
        StringBuilder sbVals = new StringBuilder();
        sbCols.append("TIMESTAMP");
        sbVals.append("?");
        int i = 2;
        for (Map.Entry<String, TypedValue<?>> entry : properties.entrySet()) {
            String sqlColName = this.dbHelper.sanitizeSqlTableAndColumnName(entry.getKey());
            sbCols.append(", ").append(sqlColName);
            sbVals.append(", ?");
        }
        logger.debug("Storing data into table {}...", (Object)sqlTableName);
        String sqlInsert = formatter.apply(SQL_INSERT_RECORD, new String[]{sqlTableName, sbCols.toString(), sbVals.toString()});
        PreparedStatement stmt = connection.prepareStatement(sqlInsert);
        stmt.setLong(1, timestamp);
        for (Map.Entry<String, TypedValue<?>> entry : properties.entrySet()) {
            DataType dataType = entry.getValue().getType();
            TypedValue<?> value = entry.getValue();
            switch (dataType) {
                case BOOLEAN: {
                    stmt.setBoolean(i, ((BooleanValue)value).getValue());
                    break;
                }
                case FLOAT: {
                    stmt.setFloat(i, ((FloatValue)value).getValue().floatValue());
                    break;
                }
                case DOUBLE: {
                    stmt.setDouble(i, ((DoubleValue)value).getValue());
                    break;
                }
                case INTEGER: {
                    stmt.setInt(i, ((IntegerValue)value).getValue());
                    break;
                }
                case LONG: {
                    stmt.setLong(i, ((LongValue)value).getValue());
                    break;
                }
                case BYTE_ARRAY: {
                    byte[] byteArrayValue = ((ByteArrayValue)value).getValue();
                    ByteArrayInputStream is = new ByteArrayInputStream(byteArrayValue);
                    stmt.setBlob(i, is, byteArrayValue.length);
                    break;
                }
                case STRING: {
                    stmt.setString(i, ((StringValue)value).getValue());
                    break;
                }
            }
            ++i;
        }
        return stmt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<WireRecord> performSQLQuery(Connection c, String query) throws SQLException {
        ArrayList<WireRecord> dataRecords;
        block14: {
            dataRecords = new ArrayList<WireRecord>();
            Throwable throwable = null;
            Object var5_6 = null;
            try {
                Statement stmt = c.createStatement();
                try {
                    try (ResultSet rset = stmt.executeQuery(query);){
                        while (rset.next()) {
                            WireRecord wireRecord = new WireRecord(this.convertSQLRowToWireRecord(rset));
                            dataRecords.add(wireRecord);
                        }
                    }
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stmt == null) throw throwable;
                    stmt.close();
                    throw throwable;
                }
                stmt.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        logger.debug("Refreshed typed values");
        return dataRecords;
    }

    private Map<String, TypedValue<?>> convertSQLRowToWireRecord(ResultSet rset) throws SQLException {
        HashMap wireRecordProperties = new HashMap();
        ResultSetMetaData rmet = rset.getMetaData();
        int i = 1;
        while (i <= rmet.getColumnCount()) {
            String fieldName = rmet.getColumnLabel(i);
            Object dbExtractedData = rset.getObject(i);
            if (Objects.isNull(fieldName)) {
                fieldName = rmet.getColumnName(i);
            }
            if (!Objects.isNull(dbExtractedData)) {
                if (dbExtractedData instanceof Blob) {
                    Blob dbExtractedBlob = (Blob)dbExtractedData;
                    int dbExtractedBlobLength = (int)dbExtractedBlob.length();
                    dbExtractedData = dbExtractedBlob.getBytes(1L, dbExtractedBlobLength);
                }
                try {
                    TypedValue value = TypedValues.newTypedValue((Object)dbExtractedData);
                    wireRecordProperties.put(fieldName, value);
                }
                catch (Exception e) {
                    logger.error("Failed to convert result for column {} (SQL type {}, Java type {}) to any of the supported Wires data type, please consider using a conversion function like CAST in your query. The result for this column will not be included in emitted envelope", (Object)fieldName, (Object)rmet.getColumnTypeName(i), (Object)dbExtractedData.getClass().getName(), (Object)e);
                }
            }
            ++i;
        }
        return wireRecordProperties;
    }
}

