/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.useradmin.osgi;

import org.apache.felix.useradmin.RoleRepositoryStore;
import org.apache.felix.useradmin.impl.EventDispatcher;
import org.apache.felix.useradmin.impl.RoleRepository;
import org.apache.felix.useradmin.impl.UserAdminImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.useradmin.UserAdmin;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

class RoleRepositoryStoreHelper
implements ServiceTrackerCustomizer {
    private final EventDispatcher m_eventDispatcher;
    private final BundleContext m_bundleContext;
    private UserAdminImpl m_userAdmin = null;
    private ServiceRegistration m_userAdminRegistration = null;

    RoleRepositoryStoreHelper(EventDispatcher eventDispatcher, BundleContext bundleContext) {
        this.m_eventDispatcher = eventDispatcher;
        this.m_bundleContext = bundleContext;
    }

    public Object addingService(ServiceReference reference) {
        if (this.m_userAdminRegistration != null) {
            return null;
        }
        RoleRepositoryStore store = (RoleRepositoryStore)this.m_bundleContext.getService(reference);
        this.m_userAdmin = new UserAdminImpl(new RoleRepository(store), this.m_eventDispatcher);
        this.m_userAdminRegistration = this.m_bundleContext.registerService(UserAdmin.class.getName(), (Object)this.m_userAdmin, null);
        return store;
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object service) {
        this.m_userAdminRegistration.unregister();
        this.m_userAdminRegistration = null;
        this.m_userAdmin.close();
        this.m_bundleContext.ungetService(reference);
    }
}

