/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.rest.configuration.api;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.ws.rs.core.Response;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.configuration.metatype.Scalar;
import org.eclipse.kura.request.handler.jaxrs.DefaultExceptionHandler;
import org.eclipse.kura.rest.configuration.api.FailureHandler;
import org.eclipse.kura.rest.configuration.api.Validable;

public class PropertyDTO
implements Validable {
    private final Object value;
    private final Scalar type;

    public PropertyDTO(Object value, Scalar type) {
        this.value = value;
        this.type = type;
    }

    public Scalar getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public void validate() {
        FailureHandler.requireParameter(this.type, "type");
        if (this.value instanceof List) {
            PropertyDTO.validateArrayProperty(this.type, (List)this.value);
        } else {
            PropertyDTO.validateSingletonProperty(this.type, this.value);
        }
    }

    private static void validateArrayProperty(Scalar type, List<?> values) {
        for (Object singletonValue : values) {
            PropertyDTO.validateSingletonProperty(type, singletonValue);
        }
    }

    private static void validateSingletonProperty(Scalar type, Object value) {
        boolean isValid;
        if (value == null) {
            return;
        }
        switch (type) {
            case LONG: 
            case DOUBLE: 
            case FLOAT: 
            case INTEGER: 
            case BYTE: 
            case SHORT: {
                isValid = value instanceof Number;
                break;
            }
            case STRING: 
            case PASSWORD: {
                isValid = value instanceof String;
                break;
            }
            case CHAR: {
                isValid = value instanceof String && ((String)value).length() == 1;
                break;
            }
            case BOOLEAN: {
                isValid = value instanceof Boolean;
                break;
            }
            default: {
                isValid = false;
            }
        }
        if (!isValid) {
            throw DefaultExceptionHandler.buildWebApplicationException((Response.Status)Response.Status.BAD_REQUEST, (String)("Invalid property for type " + type + ": " + value));
        }
    }

    public static Optional<PropertyDTO> fromConfigurationProperty(Object property) {
        return Optional.ofNullable(property).flatMap(p -> PropertyDTO.scalarFromClass(p.getClass())).map(type -> new PropertyDTO(PropertyDTO.configurationPropertyToDTOProperty(property), (Scalar)type));
    }

    public Optional<Object> toConfigurationProperty() {
        if (this.value == null) {
            return Optional.empty();
        }
        Optional<Object> asSingleton = PropertyDTO.singletonToProperty(this.value, this.type);
        if (asSingleton.isPresent()) {
            return asSingleton;
        }
        return PropertyDTO.arrayToProperty(this.value, this.type);
    }

    private static <T> T assertType(Object value, Class<T> clazz) {
        if (value.getClass() == clazz) {
            return (T)value;
        }
        throw new IllegalArgumentException();
    }

    private static <T> Function<Object, T> nullOrElse(Function<Object, T> func) {
        return v -> {
            if (v == null) {
                return null;
            }
            return func.apply(v);
        };
    }

    private static Optional<Object> singletonToProperty(Object value, Scalar type) {
        try {
            Object result;
            switch (type) {
                case BOOLEAN: {
                    result = PropertyDTO.assertType(value, Boolean.class);
                    break;
                }
                case BYTE: {
                    result = ((Number)value).byteValue();
                    break;
                }
                case CHAR: {
                    result = Character.valueOf(((String)value).charAt(0));
                    break;
                }
                case DOUBLE: {
                    result = ((Number)value).doubleValue();
                    break;
                }
                case FLOAT: {
                    result = Float.valueOf(((Number)value).floatValue());
                    break;
                }
                case INTEGER: {
                    result = ((Number)value).intValue();
                    break;
                }
                case LONG: {
                    result = ((Number)value).longValue();
                    break;
                }
                case PASSWORD: {
                    result = new Password(PropertyDTO.assertType(value, String.class));
                    break;
                }
                case SHORT: {
                    result = ((Number)value).shortValue();
                    break;
                }
                case STRING: {
                    result = PropertyDTO.assertType(value, String.class);
                    break;
                }
                default: {
                    return Optional.empty();
                }
            }
            return Optional.of(result);
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    private static Optional<Object> arrayToProperty(Object propertyValue, Scalar type) {
        try {
            A[] result;
            switch (type) {
                case BOOLEAN: {
                    result = ((List)propertyValue).stream().map(PropertyDTO.nullOrElse(v -> PropertyDTO.assertType(v, Boolean.class))).toArray(Boolean[]::new);
                    break;
                }
                case BYTE: {
                    result = ((List)propertyValue).stream().map(PropertyDTO.nullOrElse(v -> ((Number)v).byteValue())).toArray(Byte[]::new);
                    break;
                }
                case CHAR: {
                    result = ((List)propertyValue).stream().map(PropertyDTO.nullOrElse(v -> Character.valueOf(((String)v).charAt(0)))).toArray(Character[]::new);
                    break;
                }
                case DOUBLE: {
                    result = ((List)propertyValue).stream().map(PropertyDTO.nullOrElse(v -> ((Number)v).doubleValue())).toArray(Double[]::new);
                    break;
                }
                case FLOAT: {
                    result = ((List)propertyValue).stream().map(PropertyDTO.nullOrElse(v -> Float.valueOf(((Number)v).floatValue()))).toArray(Float[]::new);
                    break;
                }
                case INTEGER: {
                    result = ((List)propertyValue).stream().map(PropertyDTO.nullOrElse(v -> ((Number)v).intValue())).toArray(Integer[]::new);
                    break;
                }
                case LONG: {
                    result = ((List)propertyValue).stream().map(PropertyDTO.nullOrElse(v -> ((Number)v).longValue())).toArray(Long[]::new);
                    break;
                }
                case PASSWORD: {
                    result = ((List)propertyValue).stream().map(PropertyDTO.nullOrElse(v -> new Password(PropertyDTO.assertType(v, String.class)))).toArray(Password[]::new);
                    break;
                }
                case SHORT: {
                    result = ((List)propertyValue).stream().map(PropertyDTO.nullOrElse(v -> ((Number)v).shortValue())).toArray(Short[]::new);
                    break;
                }
                case STRING: {
                    result = ((List)propertyValue).stream().map(PropertyDTO.nullOrElse(v -> PropertyDTO.assertType(v, String.class))).toArray(String[]::new);
                    break;
                }
                default: {
                    return Optional.empty();
                }
            }
            return Optional.of(result);
        }
        catch (ClassCastException classCastException) {
            return Optional.empty();
        }
    }

    public static Optional<Scalar> scalarFormSingletonClass(Class<?> clazz) {
        Scalar result;
        if (clazz == Boolean.class) {
            result = Scalar.BOOLEAN;
        } else if (clazz == Byte.class) {
            result = Scalar.BYTE;
        } else if (clazz == Character.class) {
            result = Scalar.CHAR;
        } else if (clazz == Double.class) {
            result = Scalar.DOUBLE;
        } else if (clazz == Float.class) {
            result = Scalar.FLOAT;
        } else if (clazz == Integer.class) {
            result = Scalar.INTEGER;
        } else if (clazz == Long.class) {
            result = Scalar.LONG;
        } else if (clazz == Password.class) {
            result = Scalar.PASSWORD;
        } else if (clazz == Short.class) {
            result = Scalar.SHORT;
        } else if (clazz == String.class) {
            result = Scalar.STRING;
        } else {
            return Optional.empty();
        }
        return Optional.of(result);
    }

    public static Optional<Scalar> scalarFromClass(Class<?> clazz) {
        if (clazz.isArray()) {
            return PropertyDTO.scalarFormSingletonClass(clazz.getComponentType());
        }
        return PropertyDTO.scalarFormSingletonClass(clazz);
    }

    private static Object configurationPropertyToDTOProperty(Object property) {
        if (property instanceof Password) {
            return new String(((Password)property).getPassword());
        }
        if (property instanceof Password[]) {
            return Arrays.stream((Password[])property).map(p -> p == null ? null : new String(p.getPassword())).toArray(String[]::new);
        }
        return property;
    }
}

