/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.io.util;

import java.util.Enumeration;
import java.util.Hashtable;

public class URI {
    private String scheme;
    private String schemeSpec;
    private String auth;
    private String userInfo;
    private String host;
    private String port;
    private String path;
    private String query;
    private String fragment;
    private boolean isOpaque;
    private Hashtable params;

    public URI(String uri) {
        int ePos;
        if (uri == null) {
            throw new IllegalArgumentException("URL cannot be NULL!");
        }
        byte[] buf = uri.getBytes();
        int sPos = URI.indexOf(buf, ':', 0);
        this.scheme = URI.trim(buf, 0, sPos);
        if ((ePos = URI.indexOf(buf, '#', ++sPos)) != -1) {
            this.fragment = URI.trim(buf, ePos + 1, buf.length);
        } else {
            ePos = buf.length;
        }
        this.schemeSpec = URI.trim(buf, sPos, ePos);
        int pos = URI.indexOf(buf, '?', sPos, ePos);
        if (pos != -1) {
            this.query = URI.trim(buf, pos + 1, ePos);
            ePos = pos;
        }
        if ((pos = URI.indexOf(buf, ';', sPos, ePos)) != -1) {
            this.parseParams(buf, pos + 1, ePos);
            ePos = pos;
        }
        this.isOpaque = true;
        if (buf[sPos] == 47 && buf[sPos + 1] == 47) {
            sPos += 2;
            this.isOpaque = false;
        }
        if ((pos = URI.indexOf(buf, '/', sPos, ePos)) != -1) {
            this.path = URI.trim(buf, pos, ePos);
            ePos = pos;
        }
        this.auth = URI.trim(buf, sPos, ePos);
        if (!this.isOpaque) {
            pos = URI.indexOf(buf, '@', sPos);
            if (pos != -1) {
                this.userInfo = URI.trim(buf, sPos, pos);
                sPos = pos + 1;
            }
            if ((pos = URI.indexOf(buf, ']', sPos)) != -1) {
                this.host = URI.trim(buf, sPos, pos + 1);
                sPos = pos + 1;
            }
            if ((pos = URI.indexOf(buf, ':', sPos)) != -1) {
                this.port = URI.trim(buf, pos + 1, ePos);
                ePos = pos;
            }
            if (this.host == null) {
                this.host = URI.trim(buf, sPos, ePos);
            }
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public int getPortNumber() {
        return this.port == null ? -1 : Integer.parseInt(this.port);
    }

    public String getFragment() {
        return this.fragment;
    }

    public String getQuery() {
        return this.query;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getPath() {
        return this.path;
    }

    public String getSchemeSpecificPart() {
        return this.schemeSpec;
    }

    public String getAuthority() {
        return this.auth;
    }

    public boolean isOpaque() {
        return this.isOpaque;
    }

    public String get(String param) {
        return this.params == null ? null : (String)this.params.get(param);
    }

    public String getParams() {
        if (this.params == null || this.params.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Enumeration en = this.params.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            sb.append(";");
            sb.append(key);
            sb.append("=");
            sb.append((String)this.params.get(key));
        }
        if (sb.length() == 0) {
            return null;
        }
        return ((Object)sb).toString();
    }

    public static String getHost(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URL cannot be NULL!");
        }
        int pos = uri.indexOf("://");
        if (pos == -1) {
            throw new IllegalArgumentException("Does not have scheme");
        }
        int sPos = pos + 3;
        if ((pos = uri.indexOf(64, sPos)) != -1) {
            sPos = pos + 1;
        }
        int ePos = URI.endOfHostPort(uri, sPos);
        pos = uri.indexOf(93, sPos);
        if (pos != -1) {
            return uri.substring(sPos, pos + 1);
        }
        pos = uri.indexOf(58, sPos);
        if (sPos != -1 && pos < ePos) {
            return uri.substring(sPos, pos);
        }
        return uri.substring(sPos, ePos);
    }

    public static int getPort(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URL cannot be NULL!");
        }
        int pos = uri.indexOf("://");
        if (pos == -1) {
            throw new IllegalArgumentException("Does not have scheme");
        }
        int sPos = pos + 3;
        if ((pos = uri.indexOf(64, sPos)) != -1) {
            sPos = pos + 1;
        }
        if ((pos = uri.indexOf(93, sPos)) != -1) {
            sPos = pos + 1;
        }
        if ((sPos = uri.indexOf(":", sPos)) == -1) {
            throw new IllegalArgumentException("Port is missing " + uri);
        }
        int ePos = URI.endOfHostPort(uri, ++sPos);
        return Integer.parseInt(uri.substring(sPos, ePos));
    }

    static int endOfHostPort(String str, int spos) {
        int pos = str.indexOf("/", spos);
        int tmp = str.indexOf(";", spos);
        if (tmp != -1 && tmp < pos || pos == -1) {
            pos = tmp;
        }
        if (pos != -1) {
            return pos;
        }
        return str.length();
    }

    static int indexOf(byte[] ba, char b, int startPos) {
        return URI.indexOf(ba, b, startPos, ba.length);
    }

    static int indexOf(byte[] ba, char b, int sPos, int ePos) {
        if (sPos > ba.length || sPos < 0 || ePos > ba.length || ePos < 0 || sPos >= ePos) {
            return -1;
        }
        int i = sPos;
        while (i < ePos) {
            if (ba[i] == b) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    static String trim(byte[] buf, int s, int e) {
        if (s < e) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            ++s;
lbl4:
            // 2 sources

            ** while (s < buf.length && s < e && buf[s] == 32)
        }
lbl5:
        // 2 sources

        while (e >= 0 && e > s && buf[e - 1] == 32) {
            --e;
        }
        if (s == e) {
            return null;
        }
        return new String(buf, s, e - s);
    }

    private void parseParams(byte[] buf, int sPos, int ePos) {
        int pos;
        while (sPos < ePos && (pos = URI.indexOf(buf, ';', sPos)) != -1) {
            this.parseParam(buf, sPos, pos);
            sPos = pos + 1;
        }
        if (sPos < ePos) {
            this.parseParam(buf, sPos, ePos);
        }
    }

    private void parseParam(byte[] buf, int sPos, int ePos) {
        int rpos = URI.indexOf(buf, '=', sPos, ePos);
        if (rpos != -1) {
            String key = URI.trim(buf, sPos, rpos);
            if (key == null) {
                return;
            }
            String str = URI.trim(buf, rpos + 1, ePos);
            if (str != null) {
                if (this.params == null) {
                    this.params = new Hashtable();
                }
                this.params.put(key, str);
            }
        }
    }
}

