/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.camel.runner;

import java.util.Objects;
import java.util.concurrent.Callable;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public abstract class ScriptRunner {
    private ScriptRunner() {
    }

    public abstract Object run() throws ScriptException;

    public abstract Object run(Bindings var1) throws ScriptException;

    public abstract Object run(ScriptContext var1) throws ScriptException;

    public static ScriptRunner create(ClassLoader classLoader, String scriptEngineName, String script) throws ScriptException {
        ScriptEngine engine = ScriptRunner.createEngine(classLoader, scriptEngineName);
        return new EvalScriptRunner(classLoader, engine, script);
    }

    private static ScriptEngineManager createManager(ClassLoader classLoader) throws ScriptException {
        return ScriptRunner.runWithClassLoader(classLoader, new Callable<ScriptEngineManager>(){

            @Override
            public ScriptEngineManager call() throws Exception {
                return new ScriptEngineManager(null);
            }
        });
    }

    private static ScriptEngine createEngine(ClassLoader classLoader, final ScriptEngineManager manager, final String engineName) throws ScriptException {
        Objects.requireNonNull(manager);
        Objects.requireNonNull(engineName);
        return ScriptRunner.runWithClassLoader(classLoader, new Callable<ScriptEngine>(){

            @Override
            public ScriptEngine call() throws Exception {
                return manager.getEngineByName(engineName);
            }
        });
    }

    private static ScriptEngine createEngine(ClassLoader classLoader, String engineName) throws ScriptException {
        return ScriptRunner.createEngine(classLoader, ScriptRunner.createManager(classLoader), engineName);
    }

    public static <T> T runWithClassLoader(ClassLoader classLoader, Callable<T> code) throws ScriptException {
        if (classLoader == null) {
            try {
                return code.call();
            }
            catch (ScriptException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ScriptException(e);
            }
        }
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            T t = code.call();
            return t;
        }
        catch (ScriptException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScriptException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    /* synthetic */ ScriptRunner(ScriptRunner scriptRunner) {
        this();
    }

    private static class EvalScriptRunner
    extends ScriptRunner {
        private final ClassLoader classLoader;
        private final ScriptEngine engine;
        private final String script;

        public EvalScriptRunner(ClassLoader classLoader, ScriptEngine engine, String script) {
            super(null);
            this.classLoader = classLoader;
            this.engine = engine;
            this.script = script;
        }

        @Override
        public Object run() throws ScriptException {
            return EvalScriptRunner.runWithClassLoader(this.classLoader, new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return engine.eval(script);
                }
            });
        }

        @Override
        public Object run(final Bindings bindings) throws ScriptException {
            return EvalScriptRunner.runWithClassLoader(this.classLoader, new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return engine.eval(script, bindings);
                }
            });
        }

        @Override
        public Object run(final ScriptContext context) throws ScriptException {
            return EvalScriptRunner.runWithClassLoader(this.classLoader, new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return engine.eval(script, context);
                }
            });
        }
    }
}

