/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.rpc;

import java.util.LinkedList;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.tigris.mtoolkit.iagent.event.EventData;
import org.tigris.mtoolkit.iagent.event.EventSynchronizer;
import org.tigris.mtoolkit.iagent.internal.utils.DebugUtils;
import org.tigris.mtoolkit.iagent.pmp.PMPServer;

public class EventSynchronizerImpl
extends Thread
implements EventSynchronizer {
    private List eventQueue = new LinkedList();
    private volatile boolean running;
    private PMPServer server;
    private ServiceRegistration registration;
    private BundleContext bc;
    static /* synthetic */ Class class$0;

    EventSynchronizerImpl(BundleContext bc) {
        super("IAgent RPC Event Thread");
        this.bc = bc;
        this.setDaemon(true);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.tigris.mtoolkit.iagent.event.EventSynchronizer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registration = bc.registerService(clazz.getName(), (Object)this, null);
    }

    void setPMPServer(PMPServer server) {
        if (server == null) {
            throw new IllegalArgumentException("Cannot pass null as a parameter");
        }
        if (this.server != null) {
            throw new IllegalStateException("Event synchronizer already initialized");
        }
        this.server = server;
    }

    public void start() {
        if (this.server == null) {
            throw new IllegalStateException("Event synchronizer is not fully initialized");
        }
        this.running = true;
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.running) {
            EventData eventData = null;
            EventSynchronizerImpl eventSynchronizerImpl = this;
            synchronized (eventSynchronizerImpl) {
                try {
                    while (this.eventQueue.isEmpty() && this.running) {
                        this.debug("[run] event queue is empty >> thread will wait");
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.running = false;
                    return;
                }
                if (!this.running) {
                    return;
                }
                eventData = (EventData)this.eventQueue.remove(0);
            }
            Object convEvent = eventData.getConvertedEvent();
            String eventType = eventData.getEventType();
            this.debug("[run] sending event: " + eventData);
            this.server.event(convEvent, eventType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(EventData eventData) {
        this.debug("[enqueue] >>> eventData: " + eventData);
        if (!this.running) {
            this.debug("[enqueue] Not running anymore. Skipping...");
            return;
        }
        EventSynchronizerImpl eventSynchronizerImpl = this;
        synchronized (eventSynchronizerImpl) {
            this.eventQueue.add(eventData);
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDispatching() {
        EventSynchronizerImpl eventSynchronizerImpl = this;
        synchronized (eventSynchronizerImpl) {
            this.running = false;
            this.notifyAll();
        }
        this.unregister(this.bc);
    }

    public void unregister(BundleContext bc) {
        this.debug("[unregister] Unregistering EventSynchronizer...");
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        this.bc = null;
        this.debug("[unregister] EventSynchronizer unregistered.");
    }

    private final void debug(String message) {
        DebugUtils.debug(this, message);
    }
}

