/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.rpc;

import java.io.IOException;
import java.io.InputStream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.tigris.mtoolkit.iagent.Error;
import org.tigris.mtoolkit.iagent.internal.utils.DebugUtils;
import org.tigris.mtoolkit.iagent.rpc.spi.BundleManagerDelegate;

public class DefaultBundleManagerDelegate
implements BundleManagerDelegate {
    private BundleContext bc;

    public DefaultBundleManagerDelegate(BundleContext bc) {
        this.bc = bc;
    }

    public Object installBundle(String location, InputStream in) {
        try {
            Bundle bundle = this.bc.installBundle(location, in);
            return bundle;
        }
        catch (BundleException e) {
            Error error = new Error(-6000, "Failed to install bundle: " + e.getMessage());
            return error;
        }
    }

    public boolean isSupported() {
        return true;
    }

    public Object uninstallBundle(Bundle bundle) {
        try {
            bundle.uninstall();
            return null;
        }
        catch (BundleException e) {
            return new Error(-6000, "Failed to uninstall bundle: " + DebugUtils.toString((Exception)((Object)e)));
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object updateBundle(Bundle bundle, InputStream in) {
        try {
            try {
                bundle.update(in);
                Object var4_3 = null;
            }
            catch (BundleException e) {
                Error error = new Error(-6000, "Failed to update bundle: " + DebugUtils.toString((Exception)((Object)e)));
                Object var4_4 = null;
                try {
                    in.close();
                    return error;
                }
                catch (IOException iOException) {}
                return error;
            }
            catch (IllegalStateException illegalStateException) {
                Error error = new Error(-10000, "Bundle " + bundle.getBundleId() + " has been uninstalled");
                Object var4_5 = null;
                try {}
                catch (IOException iOException) {}
                in.close();
                return error;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            in.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        in.close();
        return null;
    }
}

