/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.pmp;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Dictionary;
import java.util.Enumeration;
import org.tigris.mtoolkit.iagent.internal.pmp.FileReader;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPInputStream;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPOutputStream;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPServiceImpl;
import org.tigris.mtoolkit.iagent.internal.pmp.RemoteObjectImpl;
import org.tigris.mtoolkit.iagent.pmp.PMPException;
import org.tigris.mtoolkit.iagent.rpc.Externalizable;

class PMPData
extends ObjectInputStream {
    protected static final String[] TYPES1 = new String[]{"int", "byte", "char", "short", "long", "float", "double", "boolean", "void"};
    protected static final String[] TYPES2 = new String[]{"java.lang.Integer", "java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.Boolean", "java.lang.Void", "java.lang.String"};
    private static final String[] TYPES3 = new String[]{"I", "B", "F", "D", "S", "C", "J", "Z"};
    private static final String JAVA_LANG = "java.lang";
    private static Class IS;
    private static Class EXT;
    private static Class DICT;
    private static final String ERRMSG1 = "Read Error";
    private static final IOException exc;
    private Class clazz;
    private ClassLoader loader;
    private static final String ERRMSG_LS = "Can't Read Strings Longer Than ";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.io.InputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IS = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.tigris.mtoolkit.iagent.rpc.Externalizable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EXT = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.util.Dictionary");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DICT = clazz3;
        exc = new IOException(ERRMSG1);
    }

    public PMPData(InputStream is) throws IOException {
        super(is);
    }

    protected Class resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
        return this.clazz.getName().equals(osc.getName()) ? this.clazz : this.loader.loadClass(osc.getName());
    }

    protected static void writeString(String s, OutputStream os) throws IOException {
        if (s == null) {
            s = new String();
        }
        byte[] b = s.getBytes();
        PMPData.writeInt(b.length, os);
        if (b.length > 0) {
            os.write(b);
        }
    }

    protected static void writeInt(int i, OutputStream os) throws IOException {
        os.write(i >>> 24 & 0xFF);
        os.write(i >>> 16 & 0xFF);
        os.write(i >>> 8 & 0xFF);
        os.write(i >>> 0 & 0xFF);
    }

    protected static void writeLong(long l, OutputStream os) throws IOException {
        os.write((int)(l >>> 56) & 0xFF);
        os.write((int)(l >>> 48) & 0xFF);
        os.write((int)(l >>> 40) & 0xFF);
        os.write((int)(l >>> 32) & 0xFF);
        os.write((int)(l >>> 24) & 0xFF);
        os.write((int)(l >>> 16) & 0xFF);
        os.write((int)(l >>> 8) & 0xFF);
        os.write((int)(l >>> 0) & 0xFF);
    }

    protected static void writeShort(short s, OutputStream os) throws IOException {
        os.write(s >>> 8 & 0xFF);
        os.write(s & 0xFF);
    }

    protected static void writeChar(char c, OutputStream os) throws IOException {
        os.write(c >>> 8 & 0xFF);
        os.write(c & 0xFF);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void writeObject(Object obj, PMPOutputStream os, boolean sendName) throws Exception {
        if (obj == null) {
            os.write(0);
            return;
        }
        os.write(1);
        if (obj instanceof InputStream) {
            if (sendName) {
                os.write(1);
                PMPData.writeString(IS.getName(), os);
            } else {
                os.write(0);
            }
            os.write((InputStream)obj);
            return;
        }
        if (obj instanceof RemoteObjectImpl) {
            if (sendName) {
                os.write(1);
                PMPData.writeString("RemoteObject", os);
            } else {
                os.write(0);
            }
            PMPData.writeInt(((RemoteObjectImpl)obj).IOR, os);
            return;
        }
        Class<?> clazz = obj.getClass();
        String className = clazz.getName();
        if (sendName) {
            os.write(1);
            PMPData.writeString(className, os);
        } else {
            os.write(0);
        }
        if (clazz.isArray()) {
            int size = Array.getLength(obj);
            if (size <= 0) {
                PMPData.writeInt(0, os);
                return;
            }
            if (className.length() == 2) {
                PMPData.writePrimrtiveArray(className, obj, size, os);
                return;
            }
            if ((className = className.substring(2, className.length() - 1)).startsWith(JAVA_LANG) && PMPData.writeLangArray(className, obj, size, os)) {
                return;
            }
            PMPData.writeInt(size, os);
            int i = 0;
            while (true) {
                if (i >= size) {
                    return;
                }
                Object difObj = Array.get(obj, i);
                if (difObj == null) {
                    PMPData.writeObject(difObj, os, false);
                } else if (difObj.getClass().getName().equals(className)) {
                    PMPData.writeObject(difObj, os, false);
                } else {
                    PMPData.writeObject(difObj, os, true);
                }
                ++i;
            }
        }
        if (obj instanceof Externalizable) {
            try {
                ((Externalizable)obj).writeObject(os);
                return;
            }
            catch (Exception exc) {
                throw new PMPException("Can't Serialize " + obj, exc);
            }
        }
        if (obj instanceof Dictionary) {
            PMPData.writeDictionary((Dictionary)obj, os);
            return;
        }
        if (!(obj instanceof Serializable)) throw new PMPException("Don't Know How To Serialize " + obj);
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            Class<?> clazz3;
            try {
                clazz3 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz2 = class$3 = clazz3;
        }
        if (clazz == clazz2) {
            PMPData.writeString((String)obj, os);
            return;
        }
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            Class<?> clazz5;
            try {
                clazz5 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz4 = class$4 = clazz5;
        }
        if (clazz == clazz4) {
            PMPData.writeLong((Long)obj, os);
            return;
        }
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            Class<?> clazz7;
            try {
                clazz7 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz6 = class$5 = clazz7;
        }
        if (clazz == clazz6) {
            PMPData.writeShort((Short)obj, os);
            return;
        }
        Class<?> clazz8 = class$6;
        if (clazz8 == null) {
            Class<?> clazz9;
            try {
                clazz9 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz8 = class$6 = clazz9;
        }
        if (clazz == clazz8) {
            PMPData.writeChar(((Character)obj).charValue(), os);
            return;
        }
        Class<?> clazz10 = class$7;
        if (clazz10 == null) {
            Class<?> clazz11;
            try {
                clazz11 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz10 = class$7 = clazz11;
        }
        if (clazz == clazz10) {
            os.write(((Byte)obj).byteValue());
            return;
        }
        Class<?> clazz12 = class$8;
        if (clazz12 == null) {
            Class<?> clazz13;
            try {
                clazz13 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz12 = class$8 = clazz13;
        }
        if (clazz == clazz12) {
            PMPData.writeInt(Float.floatToIntBits(((Float)obj).floatValue()), os);
            return;
        }
        Class<?> clazz14 = class$9;
        if (clazz14 == null) {
            Class<?> clazz15;
            try {
                clazz15 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz14 = class$9 = clazz15;
        }
        if (clazz == clazz14) {
            PMPData.writeLong(Double.doubleToLongBits((Double)obj), os);
            return;
        }
        Class<?> clazz16 = class$10;
        if (clazz16 == null) {
            Class<?> clazz17;
            try {
                clazz17 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz16 = class$10 = clazz17;
        }
        if (clazz == clazz16) {
            os.write((Boolean)obj != false ? 1 : 0);
            return;
        }
        Class<?> clazz18 = class$11;
        if (clazz18 == null) {
            Class<?> clazz19;
            try {
                clazz19 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz18 = class$11 = clazz19;
        }
        if (clazz == clazz18) {
            PMPData.writeInt((Integer)obj, os);
            return;
        }
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(obj);
        oos.flush();
    }

    private static void writeDictionary(Dictionary obj, PMPOutputStream os) throws Exception {
        PMPData.writeInt(obj.size(), os);
        Enumeration en = obj.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            PMPData.writeObject(key, os, true);
            PMPData.writeObject(obj.get(key), os, true);
        }
    }

    private static void readDictionary(Dictionary obj, ClassLoader loader, int maxSize, int strLen, PMPInputStream is) throws Exception {
        int size = PMPData.readInt(is);
        int i = 0;
        while (i < size) {
            Object key = PMPData.readObject(null, loader, is, null, maxSize, strLen, null);
            Object value = PMPData.readObject(null, loader, is, null, maxSize, strLen, null);
            obj.put(key, value);
            ++i;
        }
    }

    private static void writePrimrtiveArray(String className, Object obj, int size, OutputStream os) throws IOException {
        block8: {
            String type;
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block7: {
                                        PMPData.writeInt(size, os);
                                        type = className.substring(1, 2);
                                        if (!type.equals(TYPES3[0])) break block7;
                                        int[] iarr = (int[])obj;
                                        int i = 0;
                                        while (i < size) {
                                            PMPData.writeInt(iarr[i], os);
                                            ++i;
                                        }
                                        break block8;
                                    }
                                    if (!type.equals(TYPES3[1])) break block9;
                                    os.write((byte[])obj);
                                    break block8;
                                }
                                if (!type.equals(TYPES3[2])) break block10;
                                float[] farr = (float[])obj;
                                int i = 0;
                                while (i < size) {
                                    PMPData.writeInt(Float.floatToIntBits(farr[i]), os);
                                    ++i;
                                }
                                break block8;
                            }
                            if (!type.equals(TYPES3[3])) break block11;
                            double[] darr = (double[])obj;
                            int i = 0;
                            while (i < size) {
                                PMPData.writeLong(Double.doubleToLongBits(darr[i]), os);
                                ++i;
                            }
                            break block8;
                        }
                        if (!type.equals(TYPES3[4])) break block12;
                        short[] sarr = (short[])obj;
                        int i = 0;
                        while (i < size) {
                            PMPData.writeShort(sarr[i], os);
                            ++i;
                        }
                        break block8;
                    }
                    if (!type.equals(TYPES3[5])) break block13;
                    char[] carr = (char[])obj;
                    int i = 0;
                    while (i < size) {
                        PMPData.writeChar(carr[i], os);
                        ++i;
                    }
                    break block8;
                }
                if (!type.equals(TYPES3[6])) break block14;
                long[] larr = (long[])obj;
                int i = 0;
                while (i < size) {
                    PMPData.writeLong(larr[i], os);
                    ++i;
                }
                break block8;
            }
            if (!type.equals(TYPES3[7])) break block8;
            boolean[] zarr = (boolean[])obj;
            int i = 0;
            while (i < size) {
                os.write(zarr[i] ? 1 : 0);
                ++i;
            }
        }
    }

    private static boolean writeLangArray(String className, Object obj, int size, OutputStream os) throws IOException {
        if (className.equals(TYPES2[9])) {
            PMPData.writeInt(size, os);
            String[] strarr = (String[])obj;
            int i = 0;
            while (i < size) {
                if (strarr[i] == null) {
                    os.write(0);
                } else {
                    os.write(1);
                    PMPData.writeString(strarr[i], os);
                }
                ++i;
            }
        } else if (className.equals(TYPES2[0])) {
            PMPData.writeInt(size, os);
            Integer[] iarr = (Integer[])obj;
            int i = 0;
            while (i < size) {
                if (iarr[i] == null) {
                    os.write(0);
                } else {
                    os.write(1);
                    PMPData.writeInt(iarr[i], os);
                }
                ++i;
            }
        } else if (className.equals(TYPES2[4])) {
            PMPData.writeInt(size, os);
            Long[] larr = (Long[])obj;
            int i = 0;
            while (i < size) {
                if (larr[i] == null) {
                    os.write(0);
                } else {
                    os.write(1);
                    PMPData.writeLong(larr[i], os);
                }
                ++i;
            }
        } else if (className.equals(TYPES2[3])) {
            PMPData.writeInt(size, os);
            Short[] sarr = (Short[])obj;
            int i = 0;
            while (i < size) {
                if (sarr[i] == null) {
                    os.write(0);
                } else {
                    os.write(1);
                    PMPData.writeShort(sarr[i], os);
                }
                ++i;
            }
        } else if (className.equals(TYPES2[2])) {
            PMPData.writeInt(size, os);
            Character[] carr = (Character[])obj;
            int i = 0;
            while (i < size) {
                if (carr[i] == null) {
                    os.write(0);
                } else {
                    os.write(1);
                    PMPData.writeChar(carr[i].charValue(), os);
                }
                ++i;
            }
        } else if (className.equals(TYPES2[1])) {
            PMPData.writeInt(size, os);
            Byte[] barr = (Byte[])obj;
            int i = 0;
            while (i < size) {
                if (barr[i] == null) {
                    os.write(0);
                } else {
                    os.write(1);
                    os.write(barr[i].byteValue());
                }
                ++i;
            }
        } else if (className.equals(TYPES2[5])) {
            PMPData.writeInt(size, os);
            Float[] farr = (Float[])obj;
            int i = 0;
            while (i < size) {
                if (farr[i] == null) {
                    os.write(0);
                } else {
                    os.write(1);
                    PMPData.writeInt(Float.floatToIntBits(farr[i].floatValue()), os);
                }
                ++i;
            }
        } else if (className.equals(TYPES2[6])) {
            PMPData.writeInt(size, os);
            Double[] darr = (Double[])obj;
            int i = 0;
            while (i < size) {
                if (darr[i] == null) {
                    os.write(0);
                } else {
                    os.write(1);
                    PMPData.writeLong(Double.doubleToLongBits(darr[i]), os);
                }
                ++i;
            }
        } else if (className.equals(TYPES2[7])) {
            PMPData.writeInt(size, os);
            Boolean[] zarr = (Boolean[])obj;
            int i = 0;
            while (i < size) {
                if (zarr[i] == null) {
                    os.write(0);
                } else {
                    os.write(1);
                    os.write(zarr[i] != false ? 1 : 0);
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    protected static String readString(InputStream is, int maxLength) throws IOException {
        int strlen = PMPData.readInt(is);
        if (strlen == 0) {
            return new String();
        }
        if (maxLength > 0 && strlen > maxLength) {
            String errMsg = ERRMSG_LS + maxLength;
            throw new IOException(errMsg);
        }
        if (strlen > 0) {
            byte[] b = new byte[strlen];
            int len = 0;
            int tmp = 0;
            while (len < strlen) {
                tmp = is.read(b, len, strlen - len);
                if (tmp == -1) {
                    throw new IOException(ERRMSG1);
                }
                len += tmp;
            }
            return new String(b);
        }
        String errMsg = "Negative String Size";
        throw new IOException(errMsg);
    }

    protected static int readInt(InputStream is) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = is.read();
        if ((ch1 | (ch2 = is.read()) | (ch3 = is.read()) | (ch4 = is.read())) < 0) {
            throw new IOException(ERRMSG1);
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    private static boolean checkFlag(InputStream is) throws IOException {
        int nullflag = is.read();
        if (nullflag == -1) {
            throw new IOException(ERRMSG1);
        }
        return nullflag == 1;
    }

    protected static Object readObject(Class clazz, ClassLoader loader, PMPInputStream is, String newName, int maxSize, int strLen, String prevName) throws IOException {
        if (!PMPData.checkFlag(is)) {
            return null;
        }
        String className = new String();
        className = PMPData.checkFlag(is) ? PMPData.readString(is, strLen) : prevName;
        if (newName != null && newName.length() != 0) {
            className = newName;
        }
        if (className.equals("RemoteObject")) {
            return new RemoteObjectImpl(PMPData.readInt(is), is.c.getConnection());
        }
        if (className.startsWith("[")) {
            Object arr;
            int size = PMPData.readInt(is);
            if (maxSize > 0 && size > maxSize) {
                throw new IOException("Can't Read Arrays Longer Than " + maxSize);
            }
            if ((className = className.substring(1, className.length())).length() == 1) {
                return PMPData.readPrimitiveArray(className, size, is);
            }
            if ((className = className.substring(1, className.length() - 1)).startsWith(JAVA_LANG) && (arr = PMPData.readLangArray(className, size, is, strLen)) != null) {
                return arr;
            }
            if (clazz == null && loader != null) {
                try {
                    clazz = loader.loadClass(className);
                }
                catch (Throwable throwable) {
                    clazz = null;
                }
            }
            if (clazz == null) {
                loader = PMPServiceImpl.loader;
                try {
                    clazz = loader.loadClass(className);
                }
                catch (Throwable throwable) {
                    clazz = null;
                }
            }
            if (clazz == null) {
                throw new IOException("Can't resolve class " + className);
            }
            Object oArr = Array.newInstance(clazz, size);
            int i = 0;
            while (i < size) {
                Object next = null;
                next = newName != null ? (newName.length() != 0 ? PMPData.readObject(clazz, loader, is, className, maxSize, strLen, className) : PMPData.readObject(null, loader, is, new String(), maxSize, strLen, className)) : PMPData.readObject(null, loader, is, new String(), maxSize, strLen, className);
                Array.set(oArr, i, next);
                ++i;
            }
            return oArr;
        }
        if (className.equals(TYPES2[9])) {
            return PMPData.readString(is, strLen);
        }
        if (className.equals(TYPES1[0]) || className.equals(TYPES2[0])) {
            return new Integer(PMPData.readInt(is));
        }
        if (className.equals(TYPES1[1]) || className.equals(TYPES2[1])) {
            int b = is.read();
            if (b == -1) {
                throw new IOException(ERRMSG1);
            }
            return new Byte((byte)b);
        }
        if (className.equals(TYPES1[2]) || className.equals(TYPES2[2])) {
            return new Character(PMPData.readChar(is));
        }
        if (className.equals(TYPES1[3]) || className.equals(TYPES2[3])) {
            return new Short(PMPData.readShort(is));
        }
        if (className.equals(TYPES1[4]) || className.equals(TYPES2[4])) {
            return new Long(PMPData.readLong(is));
        }
        if (className.equals(TYPES1[5]) || className.equals(TYPES2[5])) {
            return new Float(Float.intBitsToFloat(PMPData.readInt(is)));
        }
        if (className.equals(TYPES1[6]) || className.equals(TYPES2[6])) {
            return new Double(Double.longBitsToDouble(PMPData.readLong(is)));
        }
        if (className.equals(TYPES1[7]) || className.equals(TYPES2[7])) {
            int b = is.read();
            if (b == -1) {
                throw new IOException(ERRMSG1);
            }
            return b == 1 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (clazz == null && loader != null) {
            try {
                clazz = loader.loadClass(className);
            }
            catch (Exception exception) {
                clazz = null;
            }
        }
        if (clazz == null) {
            loader = PMPServiceImpl.loader;
            try {
                clazz = loader.loadClass(className);
            }
            catch (Exception exception) {
                clazz = null;
            }
        }
        if (clazz == null) {
            throw new IOException("Can't resolve class " + className);
        }
        if (IS.isAssignableFrom(clazz)) {
            return new FileReader(is);
        }
        try {
            if (EXT.isAssignableFrom(clazz)) {
                Externalizable obj = (Externalizable)clazz.newInstance();
                obj.readObject(is);
                return obj;
            }
            if (DICT.isAssignableFrom(clazz)) {
                Dictionary obj = (Dictionary)clazz.newInstance();
                PMPData.readDictionary(obj, loader, maxSize, strLen, is);
                return obj;
            }
            PMPData ois = new PMPData(is);
            ois.clazz = clazz;
            ois.loader = loader;
            return ois.readObject();
        }
        catch (Exception exc) {
            throw exc instanceof IOException ? (IOException)exc : new IOException(exc.toString());
        }
    }

    private static Object readPrimitiveArray(String className, int size, InputStream is) throws IOException {
        if (className.equals("I")) {
            int[] iarr = new int[size];
            int i = 0;
            while (i < size) {
                iarr[i] = PMPData.readInt(is);
                ++i;
            }
            return iarr;
        }
        if (className.equals("B")) {
            byte[] barr = new byte[size];
            int read = 0;
            int tmp = 0;
            while (read < size) {
                tmp = is.read(barr, read, size - read);
                if (tmp == -1) {
                    throw exc;
                }
                read += tmp;
            }
            return barr;
        }
        if (className.equals("S")) {
            short[] sarr = new short[size];
            int i = 0;
            while (i < size) {
                sarr[i] = PMPData.readShort(is);
                ++i;
            }
            return sarr;
        }
        if (className.equals("J")) {
            long[] larr = new long[size];
            int i = 0;
            while (i < size) {
                larr[i] = PMPData.readLong(is);
                ++i;
            }
            return larr;
        }
        if (className.equals("C")) {
            char[] carr = new char[size];
            int i = 0;
            while (i < size) {
                carr[i] = PMPData.readChar(is);
                ++i;
            }
            return carr;
        }
        if (className.equals("F")) {
            float[] farr = new float[size];
            int i = 0;
            while (i < size) {
                farr[i] = Float.intBitsToFloat(PMPData.readInt(is));
                ++i;
            }
            return farr;
        }
        if (className.equals("D")) {
            double[] darr = new double[size];
            int i = 0;
            while (i < size) {
                darr[i] = Double.longBitsToDouble(PMPData.readLong(is));
                ++i;
            }
            return darr;
        }
        if (className.equals("Z")) {
            boolean[] zarr = new boolean[size];
            int i = 0;
            while (i < size) {
                int b = is.read();
                if (b == -1) {
                    throw exc;
                }
                zarr[i] = b == 1;
                ++i;
            }
            return zarr;
        }
        throw new IOException("Unknown Primitive Array Type: " + className);
    }

    private static Object readLangArray(String className, int size, InputStream is, int len) throws IOException {
        if (className.equals(TYPES2[9])) {
            String[] strarr = new String[size];
            int i = 0;
            while (i < size) {
                if (PMPData.checkFlag(is)) {
                    strarr[i] = PMPData.readString(is, len);
                }
                ++i;
            }
            return strarr;
        }
        if (className.equals(TYPES2[0])) {
            Integer[] iarr = new Integer[size];
            int i = 0;
            while (i < size) {
                if (PMPData.checkFlag(is)) {
                    iarr[i] = new Integer(PMPData.readInt(is));
                }
                ++i;
            }
            return iarr;
        }
        if (className.equals(TYPES2[1])) {
            Byte[] barr = new Byte[size];
            int i = 0;
            while (i < size) {
                if (PMPData.checkFlag(is)) {
                    byte b = (byte)is.read();
                    if (b == -1) {
                        throw new IOException(ERRMSG1);
                    }
                    barr[i] = new Byte(b);
                }
                ++i;
            }
            return barr;
        }
        if (className.equals(TYPES2[2])) {
            Character[] carr = new Character[size];
            int i = 0;
            while (i < size) {
                if (PMPData.checkFlag(is)) {
                    carr[i] = new Character(PMPData.readChar(is));
                }
                ++i;
            }
            return carr;
        }
        if (className.equals(TYPES2[3])) {
            Short[] sarr = new Short[size];
            int i = 0;
            while (i < size) {
                if (PMPData.checkFlag(is)) {
                    sarr[i] = new Short(PMPData.readShort(is));
                }
                ++i;
            }
            return sarr;
        }
        if (className.equals(TYPES2[4])) {
            Long[] larr = new Long[size];
            int i = 0;
            while (i < size) {
                if (PMPData.checkFlag(is)) {
                    larr[i] = new Long(PMPData.readLong(is));
                }
                ++i;
            }
            return larr;
        }
        if (className.equals(TYPES2[5])) {
            Float[] farr = new Float[size];
            int i = 0;
            while (i < size) {
                if (PMPData.checkFlag(is)) {
                    farr[i] = new Float(Float.intBitsToFloat(PMPData.readInt(is)));
                }
                ++i;
            }
            return farr;
        }
        if (className.equals(TYPES2[6])) {
            Double[] darr = new Double[size];
            int i = 0;
            while (i < size) {
                if (PMPData.checkFlag(is)) {
                    darr[i] = new Double(Double.longBitsToDouble(PMPData.readLong(is)));
                }
                ++i;
            }
            return darr;
        }
        if (className.equals(TYPES2[7])) {
            Boolean[] zarr = new Boolean[size];
            int i = 0;
            while (i < size) {
                if (PMPData.checkFlag(is)) {
                    int b = is.read();
                    if (b == -1) {
                        throw new IOException(ERRMSG1);
                    }
                    zarr[i] = b == 1 ? Boolean.TRUE : Boolean.FALSE;
                }
                ++i;
            }
            return zarr;
        }
        return null;
    }

    protected static char readChar(InputStream is) throws IOException {
        int ch2;
        int ch1 = is.read();
        if ((ch1 | (ch2 = is.read())) < 0) {
            throw new IOException(ERRMSG1);
        }
        return (char)((ch1 << 8) + (ch2 << 0));
    }

    protected static short readShort(InputStream is) throws IOException {
        int ch2;
        int ch1 = is.read();
        if ((ch1 | (ch2 = is.read())) < 0) {
            throw new IOException(ERRMSG1);
        }
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    protected static long readLong(InputStream is) throws IOException {
        return ((long)PMPData.readInt(is) << 32) + ((long)PMPData.readInt(is) & 0xFFFFFFFFL);
    }
}

