/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.rest.system;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.eclipse.kura.cloudconnection.request.RequestHandler;
import org.eclipse.kura.cloudconnection.request.RequestHandlerRegistry;
import org.eclipse.kura.request.handler.jaxrs.DefaultExceptionHandler;
import org.eclipse.kura.request.handler.jaxrs.JaxRsRequestHandlerProxy;
import org.eclipse.kura.rest.system.dto.ExtendedPropertiesDTO;
import org.eclipse.kura.rest.system.dto.FilterDTO;
import org.eclipse.kura.rest.system.dto.FrameworkPropertiesDTO;
import org.eclipse.kura.rest.system.dto.KuraPropertiesDTO;
import org.eclipse.kura.system.SystemService;
import org.osgi.service.useradmin.UserAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="system/v1")
public class SystemRestService {
    private static final Logger logger = LoggerFactory.getLogger(SystemRestService.class);
    private static final String DEBUG_MESSSAGE = "Processing request for resource '{}'";
    private SystemService systemService;
    private final RequestHandler requestHandler = new JaxRsRequestHandlerProxy((Object)this);

    public void bindSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    public void bindUserAdmin(UserAdmin userAdmin) {
        userAdmin.createRole("kura.permission.rest.system", 2);
    }

    public void bindRequestHandlerRegistry(RequestHandlerRegistry registry) {
        try {
            registry.registerRequestHandler("SYS-V1", this.requestHandler);
        }
        catch (Exception e) {
            logger.warn("Failed to register {} request handler", (Object)"SYS-V1", (Object)e);
        }
    }

    public void unbindRequestHandlerRegistry(RequestHandlerRegistry registry) {
        try {
            registry.unregister("SYS-V1");
        }
        catch (Exception e) {
            logger.warn("Failed to unregister {} request handler", (Object)"SYS-V1", (Object)e);
        }
    }

    @GET
    @RolesAllowed(value={"system"})
    @Path(value="/properties/framework")
    @Produces(value={"application/json"})
    public FrameworkPropertiesDTO getFrameworkProperties() {
        try {
            logger.debug(DEBUG_MESSSAGE, (Object)"/properties/framework");
            return new FrameworkPropertiesDTO(this.systemService);
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
    }

    @GET
    @RolesAllowed(value={"system"})
    @Path(value="/properties/extended")
    @Produces(value={"application/json"})
    public ExtendedPropertiesDTO getExtendedProperties() {
        try {
            logger.debug(DEBUG_MESSSAGE, (Object)"/properties/extended");
            return new ExtendedPropertiesDTO(this.systemService);
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
    }

    @GET
    @RolesAllowed(value={"system"})
    @Path(value="/properties/kura")
    @Produces(value={"application/json"})
    public KuraPropertiesDTO getKuraProperties() {
        try {
            logger.debug(DEBUG_MESSSAGE, (Object)"/properties/kura");
            return new KuraPropertiesDTO(this.systemService.getProperties());
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
    }

    @POST
    @RolesAllowed(value={"system"})
    @Path(value="/properties/framework/filter")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public FrameworkPropertiesDTO postFrameworkPropertiesFilter(FilterDTO filter) {
        try {
            logger.debug(DEBUG_MESSSAGE, (Object)"/properties/framework/filter");
            return new FrameworkPropertiesDTO(this.systemService, filter.getNames());
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
    }

    @POST
    @RolesAllowed(value={"system"})
    @Path(value="/properties/extended/filter")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public ExtendedPropertiesDTO postExtendedPropertiesFilter(FilterDTO filter) {
        try {
            logger.debug(DEBUG_MESSSAGE, (Object)"/properties/extended/filter");
            return new ExtendedPropertiesDTO(this.systemService, filter.getGroupNames());
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
    }

    @POST
    @RolesAllowed(value={"system"})
    @Path(value="/properties/kura/filter")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public KuraPropertiesDTO postKuraPropertiesFilter(FilterDTO filter) {
        try {
            logger.debug(DEBUG_MESSSAGE, (Object)"/properties/kura/filter");
            return new KuraPropertiesDTO(this.systemService.getProperties(), filter.getNames());
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
    }
}

