/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.cloudconnection.eclipseiot.mqtt.message;

public enum MessageType {
    TELEMETRY_QOS_0("telemetryQos0", 0, 7, "t"),
    TELEMETRY_QOS_1("telemetryQos1", 1, 7, "t"),
    EVENT("event", 1, 5, "e"),
    ALERT("alert", 1, 2, "a"),
    CONTROL("control", 0, 2, "c");

    private String type;
    private int qos;
    private int priority;
    private String topicPrefix;

    private MessageType(String type, int qos, int priority, String topicPrefix) {
        this.type = type;
        this.qos = qos;
        this.priority = priority;
        this.topicPrefix = topicPrefix;
    }

    public String getType() {
        return this.type;
    }

    public int getQos() {
        return this.qos;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    public static MessageType fromValue(String v) {
        MessageType[] messageTypeArray = MessageType.values();
        int n = messageTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MessageType mt = messageTypeArray[n2];
            if (mt.type.equals(v)) {
                return mt;
            }
            ++n2;
        }
        throw new IllegalArgumentException(v);
    }
}

