/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.ds;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.Reference;
import org.apache.felix.scr.ScrService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.dto.ServiceReferenceDTO;
import org.osgi.service.component.ComponentInstance;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentConfigurationDTO;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.osgi.service.component.runtime.dto.ReferenceDTO;
import org.osgi.service.component.runtime.dto.SatisfiedReferenceDTO;
import org.osgi.service.component.runtime.dto.UnsatisfiedReferenceDTO;

@Deprecated
public class ScrServiceImpl
implements ScrService {
    final ServiceComponentRuntime scr;
    final BundleContext context;

    ScrServiceImpl(ServiceComponentRuntime scr, BundleContext context) {
        this.scr = scr;
        this.context = context.getBundle("System Bundle").getBundleContext();
    }

    @Override
    public Component[] getComponents() {
        return this.toComponents(this.scr.getComponentDescriptionDTOs(new Bundle[0]));
    }

    private Component[] toComponents(Collection<ComponentDescriptionDTO> componentDescriptionDTOs) {
        ArrayList<Component> components = new ArrayList<Component>();
        for (ComponentDescriptionDTO dto : componentDescriptionDTOs) {
            Component component = this.toComponent(dto);
            if (component == null) continue;
            components.add(component);
        }
        return components.isEmpty() ? null : components.toArray(new Component[0]);
    }

    @Override
    public Component getComponent(long componentId) {
        for (ComponentDescriptionDTO dto : this.scr.getComponentDescriptionDTOs(new Bundle[0])) {
            Long id = (Long)dto.properties.get("component.id");
            if (componentId != id) continue;
            return this.toComponent(dto);
        }
        return null;
    }

    private Component toComponent(ComponentDescriptionDTO dto) {
        Collection configs = this.scr.getComponentConfigurationDTOs(dto);
        if (configs.isEmpty()) {
            return null;
        }
        return new ComponentImpl((ComponentConfigurationDTO)configs.iterator().next());
    }

    @Override
    public Component[] getComponents(String componentName) {
        ArrayList<ComponentDescriptionDTO> dtos = new ArrayList<ComponentDescriptionDTO>();
        for (ComponentDescriptionDTO dto : this.scr.getComponentDescriptionDTOs(new Bundle[0])) {
            if (!componentName.equals(dto.name)) continue;
            dtos.add(dto);
        }
        return this.toComponents(dtos);
    }

    @Override
    public Component[] getComponents(Bundle bundle) {
        return this.toComponents(this.scr.getComponentDescriptionDTOs(new Bundle[]{bundle}));
    }

    ServiceReference<?> getServiceReference(long id) {
        try {
            ServiceReference[] refs = this.context.getServiceReferences(null, "(service.id=" + id + ")");
            if (refs != null && refs.length > 0) {
                return refs[0];
            }
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    class ComponentImpl
    implements Component {
        private final ComponentConfigurationDTO config;

        ComponentImpl(ComponentConfigurationDTO config) {
            this.config = config;
        }

        @Override
        public long getId() {
            return this.config.id;
        }

        @Override
        public String getName() {
            return this.config.description.name;
        }

        @Override
        public int getState() {
            switch (this.config.state) {
                case 8: {
                    return 16;
                }
                case 4: {
                    return 32;
                }
                case 1: {
                    return 4;
                }
                case 2: {
                    return 4;
                }
            }
            return 1;
        }

        @Override
        public Bundle getBundle() {
            return ScrServiceImpl.this.context.getBundle(this.config.description.bundle.id);
        }

        @Override
        public String getFactory() {
            return this.config.description.factory;
        }

        @Override
        public boolean isServiceFactory() {
            return "bundle".equals(this.config.description.scope);
        }

        @Override
        public String getClassName() {
            return this.config.description.implementationClass;
        }

        @Override
        public boolean isDefaultEnabled() {
            return this.config.description.defaultEnabled;
        }

        @Override
        public boolean isImmediate() {
            return this.config.description.immediate;
        }

        @Override
        public String[] getServices() {
            return this.config.description.serviceInterfaces;
        }

        @Override
        public Dictionary getProperties() {
            return new Hashtable(this.config.description.properties);
        }

        @Override
        public Reference[] getReferences() {
            if (this.config.description.references.length == 0) {
                return null;
            }
            HashMap<String, ReferenceDTO> referenceDTOs = new HashMap<String, ReferenceDTO>();
            ReferenceDTO[] referenceDTOArray = this.config.description.references;
            int n = this.config.description.references.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceDTO reference = referenceDTOArray[n2];
                referenceDTOs.put(reference.name, reference);
                ++n2;
            }
            HashMap<String, SatisfiedReferenceDTO> satisfiedDTOs = new HashMap<String, SatisfiedReferenceDTO>();
            SatisfiedReferenceDTO[] satisfiedReferenceDTOArray = this.config.satisfiedReferences;
            int n3 = this.config.satisfiedReferences.length;
            n = 0;
            while (n < n3) {
                SatisfiedReferenceDTO satisfied = satisfiedReferenceDTOArray[n];
                satisfiedDTOs.put(satisfied.name, satisfied);
                ++n;
            }
            HashMap<String, UnsatisfiedReferenceDTO> unsatisfiedDTOs = new HashMap<String, UnsatisfiedReferenceDTO>();
            UnsatisfiedReferenceDTO[] unsatisfiedReferenceDTOArray = this.config.unsatisfiedReferences;
            int n4 = this.config.unsatisfiedReferences.length;
            n3 = 0;
            while (n3 < n4) {
                UnsatisfiedReferenceDTO unsatisfied = unsatisfiedReferenceDTOArray[n3];
                unsatisfiedDTOs.put(unsatisfied.name, unsatisfied);
                ++n3;
            }
            return this.toReferences(referenceDTOs, satisfiedDTOs, unsatisfiedDTOs);
        }

        private Reference[] toReferences(Map<String, ReferenceDTO> referenceDTOs, Map<String, SatisfiedReferenceDTO> satisfiedDTOs, Map<String, UnsatisfiedReferenceDTO> unsatisfiedDTOs) {
            ArrayList<ReferenceBase> references = new ArrayList<ReferenceBase>();
            for (Map.Entry<String, SatisfiedReferenceDTO> entry : satisfiedDTOs.entrySet()) {
                references.add(new SatsifiedReference(entry.getValue(), referenceDTOs.get(entry.getValue().name)));
            }
            for (Map.Entry<String, SatisfiedReferenceDTO> entry : unsatisfiedDTOs.entrySet()) {
                references.add(new UnsatsifiedReference((UnsatisfiedReferenceDTO)entry.getValue(), referenceDTOs.get(((UnsatisfiedReferenceDTO)entry.getValue()).name)));
            }
            return references.toArray(new Reference[0]);
        }

        public ComponentInstance<Object> getComponentInstance() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public String getActivate() {
            return this.config.description.activate;
        }

        @Override
        public boolean isActivateDeclared() {
            return this.config.description.activate != null;
        }

        @Override
        public String getDeactivate() {
            return this.config.description.deactivate;
        }

        @Override
        public boolean isDeactivateDeclared() {
            return this.config.description.deactivate != null;
        }

        @Override
        public String getModified() {
            return this.config.description.modified;
        }

        @Override
        public String getConfigurationPolicy() {
            return this.config.description.configurationPolicy;
        }

        @Override
        public void enable() {
            ScrServiceImpl.this.scr.disableComponent(this.config.description);
        }

        @Override
        public void disable() {
            ScrServiceImpl.this.scr.disableComponent(this.config.description);
        }
    }

    abstract class ReferenceBase
    implements Reference {
        protected final ReferenceDTO reference;

        ReferenceBase(ReferenceDTO reference) {
            this.reference = reference;
        }

        @Override
        public String getName() {
            return this.reference.name;
        }

        @Override
        public String getServiceName() {
            return this.reference.interfaceName;
        }

        @Override
        public boolean isOptional() {
            return this.reference.cardinality.startsWith("0");
        }

        @Override
        public boolean isMultiple() {
            return this.reference.cardinality.startsWith("1");
        }

        @Override
        public boolean isStatic() {
            return "static".equals(this.reference.policy);
        }

        @Override
        public String getTarget() {
            return this.reference.target;
        }

        @Override
        public String getBindMethodName() {
            return this.reference.bind;
        }

        @Override
        public String getUnbindMethodName() {
            return this.reference.unbind;
        }

        @Override
        public String getUpdatedMethodName() {
            return this.reference.updated;
        }
    }

    class SatsifiedReference
    extends ReferenceBase {
        private final SatisfiedReferenceDTO satisfied;

        SatsifiedReference(SatisfiedReferenceDTO satisifed, ReferenceDTO reference) {
            super(reference);
            this.satisfied = satisifed;
        }

        @Override
        public ServiceReference[] getServiceReferences() {
            ArrayList serviceReferences = new ArrayList();
            ServiceReferenceDTO[] serviceReferenceDTOArray = this.satisfied.boundServices;
            int n = this.satisfied.boundServices.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReferenceDTO serviceRefDTO = serviceReferenceDTOArray[n2];
                ServiceReference<?> ref = ScrServiceImpl.this.getServiceReference(serviceRefDTO.id);
                if (ref != null) {
                    serviceReferences.add(ref);
                }
                ++n2;
            }
            return serviceReferences.isEmpty() ? null : serviceReferences.toArray(new ServiceReference[0]);
        }

        @Override
        public boolean isSatisfied() {
            return true;
        }
    }

    class UnsatsifiedReference
    extends ReferenceBase {
        private final UnsatisfiedReferenceDTO unsatisfied;

        UnsatsifiedReference(UnsatisfiedReferenceDTO unsatisifed, ReferenceDTO reference) {
            super(reference);
            this.unsatisfied = unsatisifed;
        }

        @Override
        public ServiceReference[] getServiceReferences() {
            ArrayList serviceReferences = new ArrayList();
            ServiceReferenceDTO[] serviceReferenceDTOArray = this.unsatisfied.targetServices;
            int n = this.unsatisfied.targetServices.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReferenceDTO serviceRefDTO = serviceReferenceDTOArray[n2];
                ServiceReference<?> ref = ScrServiceImpl.this.getServiceReference(serviceRefDTO.id);
                if (ref != null) {
                    serviceReferences.add(ref);
                }
                ++n2;
            }
            return serviceReferences.isEmpty() ? null : serviceReferences.toArray(new ServiceReference[0]);
        }

        @Override
        public boolean isSatisfied() {
            return false;
        }
    }
}

