/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.util.validation;

import java.util.Map;
import org.eclipse.kura.util.configuration.Property;

public class ValidatorOptions {
    private int passwordMinimumLength = 8;
    private boolean passwordRequireDigits = false;
    private boolean passwordRequireBothCases = false;
    private boolean passwordRequireSpecialChars = false;
    private static final String NEW_PASSW_MIN_LENGTH_PROP = "new.password.min.length";
    private static final String NEW_PASSW_REQUIRE_DIGITS = "new.password.require.digits";
    private static final String NEW_PASSW_REQUIRE_SPECIAL_CHARS = "new.password.require.special.characters";
    private static final String NEW_PASSW_REQUIRE_BOTH_CASES = "new.password.require.both.cases";
    private final Property<Integer> newPasswMinLenghthProperty = new Property<Integer>("new.password.min.length", 8);
    private final Property<Boolean> newPassRequireDigits = new Property<Boolean>("new.password.require.digits", false);
    private final Property<Boolean> newPassRequireSpecialChars = new Property<Boolean>("new.password.require.special.characters", false);
    private final Property<Boolean> newPassRequireBothCases = new Property<Boolean>("new.password.require.both.cases", false);

    public ValidatorOptions(int passwordMinimumLength, boolean passwordRequireDigits, boolean passwordRequireBothCases, boolean passwordRequireSpecialChars) {
        this.passwordMinimumLength = passwordMinimumLength;
        this.passwordRequireDigits = passwordRequireDigits;
        this.passwordRequireSpecialChars = passwordRequireSpecialChars;
        this.passwordRequireBothCases = passwordRequireBothCases;
    }

    public ValidatorOptions(Map<String, Object> configurationProperties) {
        if (configurationProperties != null) {
            this.passwordMinimumLength = this.newPasswMinLenghthProperty.get(configurationProperties);
            this.passwordRequireDigits = this.newPassRequireDigits.get(configurationProperties);
            this.passwordRequireSpecialChars = this.newPassRequireSpecialChars.get(configurationProperties);
            this.passwordRequireBothCases = this.newPassRequireBothCases.get(configurationProperties);
        }
    }

    public int isPasswordMinimumLength() {
        return this.passwordMinimumLength;
    }

    public boolean isPasswordRequireDigits() {
        return this.passwordRequireDigits;
    }

    public boolean isPasswordRequireBothCases() {
        return this.passwordRequireBothCases;
    }

    public boolean isPasswordRequireSpecialChars() {
        return this.passwordRequireSpecialChars;
    }
}

