/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.position;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloudconnection.request.RequestHandler;
import org.eclipse.kura.cloudconnection.request.RequestHandlerRegistry;
import org.eclipse.kura.position.PositionService;
import org.eclipse.kura.request.handler.jaxrs.DefaultExceptionHandler;
import org.eclipse.kura.request.handler.jaxrs.JaxRsRequestHandlerProxy;
import org.eclipse.kura.rest.position.api.DateTimeDTO;
import org.eclipse.kura.rest.position.api.IsLockedDTO;
import org.eclipse.kura.rest.position.api.PositionDTO;
import org.osgi.service.useradmin.UserAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/position/v1")
public class PositionRestService {
    private static final String POSITION_IS_NOT_LOCKED = "Position is not locked";
    private static final Logger logger = LoggerFactory.getLogger(PositionRestService.class);
    private static final String APP_ID = "POS-V1";
    private static final String KURA_PERMISSION_REST_CONFIGURATION_ROLE = "kura.permission.rest.position";
    private final RequestHandler requestHandler = new JaxRsRequestHandlerProxy((Object)this);
    private PositionService positionServiceImpl;

    public void setPositionServiceImpl(PositionService positionServiceImpl) {
        this.positionServiceImpl = positionServiceImpl;
    }

    public void setUserAdmin(UserAdmin userAdmin) {
        userAdmin.createRole(KURA_PERMISSION_REST_CONFIGURATION_ROLE, 2);
    }

    public void setRequestHandlerRegistry(RequestHandlerRegistry registry) {
        try {
            registry.registerRequestHandler(APP_ID, this.requestHandler);
        }
        catch (Exception e) {
            logger.warn("failed to register {} request handler", (Object)APP_ID, (Object)e);
        }
    }

    public void unsetRequestHandlerRegistry(RequestHandlerRegistry registry) {
        try {
            registry.unregister(APP_ID);
        }
        catch (KuraException e) {
            logger.warn("failed to unregister {} request handler", (Object)APP_ID, (Object)e);
        }
    }

    @GET
    @RolesAllowed(value={"position"})
    @Path(value="/position")
    @Produces(value={"application/json"})
    public PositionDTO getPosition() {
        if (this.positionServiceImpl.isLocked()) {
            return new PositionDTO(this.positionServiceImpl.getPosition());
        }
        throw DefaultExceptionHandler.toWebApplicationException((KuraException)new KuraException(KuraErrorCode.SERVICE_UNAVAILABLE, new Object[]{POSITION_IS_NOT_LOCKED}));
    }

    @GET
    @RolesAllowed(value={"position"})
    @Path(value="/dateTime")
    @Produces(value={"application/json"})
    public DateTimeDTO getLocalDateTime() {
        if (this.positionServiceImpl.isLocked()) {
            return new DateTimeDTO(this.positionServiceImpl.getDateTime());
        }
        throw DefaultExceptionHandler.toWebApplicationException((KuraException)new KuraException(KuraErrorCode.SERVICE_UNAVAILABLE, new Object[]{POSITION_IS_NOT_LOCKED}));
    }

    @GET
    @RolesAllowed(value={"position"})
    @Path(value="/isLocked")
    @Produces(value={"application/json"})
    public IsLockedDTO getIsLocked() {
        try {
            return new IsLockedDTO(this.positionServiceImpl.isLocked());
        }
        catch (Exception e) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)e);
        }
    }
}

