/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.common.commands.contrib.viewpoint.representation.command;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.kitalpha.model.common.commands.action.ModelCommand;
import org.polarsys.kitalpha.model.common.commands.contrib.viewpoint.representation.Activator;
import org.polarsys.kitalpha.model.common.commands.contrib.viewpoint.representation.command.SiriusViewpointRepresentationHandler;
import org.polarsys.kitalpha.model.common.commands.exception.ModelCommandException;
import org.polarsys.kitalpha.model.common.scrutiny.analyzer.ModelScrutinyException;
import org.polarsys.kitalpha.model.common.scrutiny.contrib.viewpoints.scrutinizes.UsedAFViewpoints;
import org.polarsys.kitalpha.model.common.scrutiny.interfaces.IScrutinize;
import org.polarsys.kitalpha.model.common.scrutiny.registry.ModelScrutinyRegistry;
import org.polarsys.kitalpha.model.common.share.ui.utilities.vp.tree.ViewpointTreeContainer;

public class HandleViewpointRepresentationCommand
extends ModelCommand {
    public void exec(ModelScrutinyRegistry analysis, Resource resource, IProgressMonitor monitor) throws ModelCommandException {
        if (resource.getURI().lastSegment() == null || !resource.getURI().lastSegment().endsWith("aird")) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        Session session = SessionManager.INSTANCE.getExistingSession(resource.getURI());
        if (session == null) {
            this.saveResources(resource);
            session = SessionManager.INSTANCE.getSession(resource.getURI(), (IProgressMonitor)subMonitor);
        }
        if (!session.isOpen()) {
            session.open((IProgressMonitor)subMonitor);
        }
        try {
            UsedAFViewpoints usedVpFinder;
            ModelScrutinyRegistry.RegistryElement regElt = analysis.getRegistryElement(this.getModelAnalysisID());
            if (regElt != null && (usedVpFinder = this.getUsedAFFinder(regElt)) != null) {
                ViewpointTreeContainer analysisResult = usedVpFinder.getAnalysisResult();
                this.clean(analysisResult, session, monitor);
            }
        }
        catch (ModelScrutinyException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.kitalpha.model.common.commands.contrib.viewpoint.representation", e.getMessage(), (Throwable)e));
        }
    }

    private void saveResources(Resource resource) {
        for (Resource r : resource.getResourceSet().getResources()) {
            try {
                if (r.getURI() == null || !r.getURI().isPlatformResource()) continue;
                r.save(null);
            }
            catch (IOException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.kitalpha.model.common.commands.contrib.viewpoint.representation", e.getMessage(), (Throwable)e));
            }
        }
    }

    private void clean(ViewpointTreeContainer analysisResult, Session session, IProgressMonitor monitor) {
        Collection viewpointToRemove = analysisResult.getViewpointToRemove();
        new SiriusViewpointRepresentationHandler(session, viewpointToRemove, monitor).clean();
    }

    private UsedAFViewpoints getUsedAFFinder(ModelScrutinyRegistry.RegistryElement regElt) {
        Collection finders = regElt.getFinders();
        for (IScrutinize iFinder : finders) {
            if (!(iFinder instanceof UsedAFViewpoints)) continue;
            return (UsedAFViewpoints)iFinder;
        }
        return null;
    }
}

