/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.ui.launch.tabs.widgets;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.polarsys.kitalpha.composer.api.Parameter;
import org.polarsys.kitalpha.composer.extension.points.ParameterizedComposerElement;
import org.polarsys.kitalpha.composer.ui.providers.ColumnParametersLabelProvider;
import org.polarsys.kitalpha.composer.ui.providers.ColumnValuesLabelProvider;
import org.polarsys.kitalpha.composer.ui.providers.ComboContentProvider;
import org.polarsys.kitalpha.composer.ui.providers.ComboLabelProvider;
import org.polarsys.kitalpha.composer.ui.providers.ComboViewerFilter;
import org.polarsys.kitalpha.composer.ui.providers.ITableEditingListener;
import org.polarsys.kitalpha.composer.ui.providers.TableContentProvider;
import org.polarsys.kitalpha.composer.ui.providers.TableEditingSupport;

public class AtomicWidget {
    ComboViewer comboViewer;
    ComboViewerFilter filter;
    TableViewer tableViewer;
    Composite composite;
    private static final String VALIDATION_STR = "validate";
    private static final String VALIDATE_TOOLTIP = "Allows to validate parameters";

    public AtomicWidget(Composite composite) {
        this.composite = composite;
    }

    public TableViewer createTableViewer(ITableEditingListener listener) {
        this.tableViewer = new TableViewer(this.composite, 67584);
        Table table = this.tableViewer.getTable();
        GridData gd = new GridData(1808);
        gd.heightHint = 130;
        gd.widthHint = 100;
        gd.grabExcessVerticalSpace = false;
        table.setLayoutData((Object)gd);
        table.setFont(this.composite.getFont());
        String[] columnNames = new String[]{"Parameter", "Value"};
        int[] columnWidths = new int[]{300, 205};
        int[] columnAlignements = new int[]{16384, 0x1000000};
        TableColumn[] tableColumn = new TableColumn[columnNames.length];
        int i = 0;
        while (i < columnNames.length) {
            TableColumn column = new TableColumn(table, columnAlignements[i]);
            column.setText(columnNames[i]);
            column.setWidth(columnWidths[i]);
            tableColumn[i] = column;
            ++i;
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        TableViewerColumn parameters = new TableViewerColumn(this.tableViewer, tableColumn[0]);
        TableViewerColumn values = new TableViewerColumn(this.tableViewer, tableColumn[1]);
        ColumnParametersLabelProvider providerP = new ColumnParametersLabelProvider();
        ColumnValuesLabelProvider providerV = new ColumnValuesLabelProvider();
        parameters.setLabelProvider((CellLabelProvider)providerP);
        values.setLabelProvider((CellLabelProvider)providerV);
        TableEditingSupport edit = new TableEditingSupport((ColumnViewer)this.tableViewer, listener);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewer, (int)2);
        values.setEditingSupport((EditingSupport)edit);
        return this.tableViewer;
    }

    public ComboViewer createComboViewer(boolean filtering) {
        this.comboViewer = new ComboViewer(this.composite, 131084);
        Combo combo = this.comboViewer.getCombo();
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        combo.setLayoutData((Object)gd);
        this.comboViewer.setUseHashlookup(true);
        this.comboViewer.setContentProvider((IContentProvider)new ComboContentProvider());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new ComboLabelProvider());
        this.comboViewer.setSorter(new ViewerSorter());
        if (filtering) {
            this.filter = new ComboViewerFilter((Viewer)this.comboViewer);
            this.comboViewer.setFilters(new ViewerFilter[]{this.filter});
        }
        return this.comboViewer;
    }

    public Text createText(Composite composite) {
        Text text = new Text(composite, 2052);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        text.setLayoutData((Object)gd);
        return text;
    }

    public Button createValidationButton() {
        Button button = this.createButton(this.composite, VALIDATION_STR, VALIDATE_TOOLTIP);
        return button;
    }

    public Button createButton(Composite composite, String text, String tooltip) {
        Button button = new Button(composite, 8);
        button.setText(text);
        button.setToolTipText(tooltip);
        return button;
    }

    public Button createRadioButton(Composite composite, String text, String tooltip) {
        Button button = new Button(composite, 16);
        button.setText(text);
        button.setToolTipText(tooltip);
        return button;
    }

    public Label createLabel(String text) {
        Label label = new Label(this.composite, 16384);
        label.setText(text);
        return label;
    }

    public Label createEmptyLabel(boolean span) {
        return this.createEmptyLabel(span, 0);
    }

    public Label createEmptyLabel(boolean span, int style) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        if (span) {
            gd.horizontalSpan = 2;
        }
        Label label = new Label(this.composite, style);
        label.setLayoutData((Object)gd);
        return label;
    }

    public void setNsUri(String uri) {
        this.filter.setNsUri(uri);
        this.comboViewer.refresh();
    }

    public int initializeComboViewer(String match) {
        int index = 0;
        Combo combo = this.comboViewer.getCombo();
        int item = 0;
        while (item < combo.getItems().length) {
            if (combo.getItem(item).equals(match)) {
                index = item;
                combo.select(item);
            }
            ++item;
        }
        return index;
    }

    public void intializeDescription(Label description, int index) {
        Object obj = this.comboViewer.getElementAt(index);
        if (obj != null) {
            IConfigurationElement element = (IConfigurationElement)obj;
            String d = element.getAttribute("Description");
            description.setText(d);
        }
    }

    public void setComboSelection(Object o) {
        StructuredSelection selection = new StructuredSelection(o);
        this.comboViewer.setSelection((ISelection)selection);
    }

    public Map<String, String> getMapFromTable() {
        Collection parameters = (Collection)this.tableViewer.getInput();
        HashMap<String, String> params = new HashMap<String, String>();
        if (parameters != null) {
            for (Parameter p : parameters) {
                params.put(p.getName(), p.getValue());
            }
        }
        return params;
    }

    public Map<String, Parameter> buildMapFromString(Map<String, String> map, ParameterizedComposerElement reference) {
        Map goodMap = null;
        if (reference != null && (goodMap = reference.getParameters()) != null) {
            for (Map.Entry parameterEntry : goodMap.entrySet()) {
                Parameter parameter = (Parameter)parameterEntry.getValue();
                String param = (String)parameterEntry.getKey();
                if (!map.containsKey(param)) {
                    map.put(param, parameter.getValue());
                    continue;
                }
                String stringValue = map.get(param);
                parameter.setName(param);
                parameter.setValue(stringValue);
                goodMap.put(param, parameter);
            }
        }
        return goodMap;
    }
}

