/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.transposer.transformation.emf.activities;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.polarsys.kitalpha.cadence.core.api.IActivity;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.cadence.core.api.parameter.DeclaredParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.ParameterError;
import org.polarsys.kitalpha.transposer.api.ITransposerWorkflow;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.transposer.transformation.context.GenericTransformationContext;
import org.polarsys.kitalpha.transposer.transformation.emf.resource.ResourceUtil;
import org.polarsys.kitalpha.transposer.transformation.emf.traces.Trace;
import org.polarsys.kitalpha.transposer.transformation.emf.traces.TraceRepository;
import org.polarsys.kitalpha.transposer.transformation.emf.traces.TracesFactory;
import org.polarsys.kitalpha.transposer.transformation.trace.TraceHelper;

public class TraceSaver
implements IActivity,
ITransposerWorkflow {
    public static final String ID = "org.polarsys.kitalpha.transposer.transformation.emf.trace.save";

    public Collection<DeclaredParameter> getParameters() {
        return null;
    }

    public IStatus run(ActivityParameters activityParams_p) {
        IContext context = (IContext)activityParams_p.getParameter("TransposerContext").getValue();
        TraceRepository tracesRepo = null;
        if (context == null) {
            return new Status(4, "org.polarsys.kitalpha.transposer.transformation.emf", "Context in not initialized in the Transposer Workflow");
        }
        if (context.exists((Object)"TraceModelRepository")) {
            tracesRepo = (TraceRepository)context.get((Object)"TraceModelRepository");
            tracesRepo.getTraces().clear();
        }
        if (context instanceof GenericTransformationContext) {
            this.handleTraces(tracesRepo, (GenericTransformationContext)context);
        }
        if (tracesRepo != null) {
            this.saveTraceModel(tracesRepo, context);
        }
        return Status.OK_STATUS;
    }

    private void handleTraces(TraceRepository rep_p, GenericTransformationContext context_p) {
        TraceHelper helper = context_p.getTraceHelper();
        if (helper != null) {
            for (org.polarsys.kitalpha.transposer.transformation.trace.Trace agnosticTrace : helper.getTraces()) {
                Trace emfTrace = TracesFactory.eINSTANCE.createTrace();
                if (this.isHandled(agnosticTrace.getSource())) {
                    emfTrace.setSource((EObject)agnosticTrace.getSource());
                }
                if (this.isHandled(agnosticTrace.getTarget())) {
                    emfTrace.setTarget((EObject)agnosticTrace.getTarget());
                }
                emfTrace.setRole(agnosticTrace.getRole());
                if (emfTrace.getSource() == null || emfTrace.getTarget() == null || emfTrace.getRole() == null) continue;
                rep_p.getTraces().add((Object)emfTrace);
            }
        }
    }

    private boolean isHandled(Object object_p) {
        return object_p != null && object_p instanceof EObject && ((EObject)object_p).eResource() != null;
    }

    private void saveTraceModel(TraceRepository rep_p, IContext context_p) {
        ResourceSetImpl rs = null;
        if (context_p.get((Object)"TransposerResourceSet") != null) {
            Object set = context_p.get((Object)"TransposerResourceSet");
            if (set instanceof ResourceSet) {
                rs = (ResourceSet)set;
            }
        } else {
            rs = new ResourceSetImpl();
            context_p.put((Object)"TransposerResourceSet", (Object)rs);
        }
        if (rep_p.eResource() != null && rep_p.eResource().getResourceSet() != null && rep_p.eResource().isLoaded() && rep_p.eResource().isModified()) {
            ResourceUtil.saveResource(rep_p.eResource());
        }
    }

    public Map<String, ParameterError<?>> validateParameters(ActivityParameters valuedParameters_p) {
        return null;
    }
}

