/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import org.eclipse.january.dataset.SliceIterator;
import org.eclipse.january.dataset.SliceND;

public class StrideIterator
extends SliceIterator {
    private int[] stride;
    private int[] delta;
    private int nstart;
    private int element;
    private boolean zero;

    public StrideIterator(int[] shape) {
        this(shape, null, 0);
    }

    public StrideIterator(int isize, int[] shape) {
        this(isize, shape, null, 0);
    }

    public StrideIterator(int[] shape, int[] strides) {
        this(shape, strides, 0);
    }

    public StrideIterator(int[] shape, int[] strides, int offset) {
        this(1, shape, strides, offset);
    }

    public StrideIterator(int isize, int[] shape, int[] strides, int offset) {
        this(isize, shape, strides, offset, 0);
    }

    public StrideIterator(int isize, int[] shape, int[] strides, int offset, int element) {
        int rank = shape.length;
        this.start = new int[rank];
        this.stop = shape;
        this.step = new int[rank];
        Arrays.fill(this.step, 1);
        this.sshape = shape;
        this.init(isize, shape, strides, offset, element);
        this.reset();
    }

    public StrideIterator(int isize, int[] shape, int[] start, int[] stop, int[] step) {
        this(isize, shape, null, 0, start, stop, step);
    }

    public StrideIterator(int isize, int[] shape, int[] oStrides, int oOffset, int[] start, int[] stop, int[] step) {
        this(isize, shape, oStrides, oOffset, new SliceND(shape, start, stop, step));
    }

    public StrideIterator(int isize, int[] shape, int[] strides, int offset, SliceND slice) {
        this.start = slice.getStart();
        this.stop = slice.getStop();
        this.step = slice.getStep();
        this.sshape = slice.getShape();
        this.init(isize, shape, strides, offset, 0);
        this.reset();
    }

    private void init(int isize, int[] shape, int[] strides, int offset, int element) {
        this.isize = isize;
        this.istep = isize;
        this.shape = shape;
        int rank = shape.length;
        this.endrank = rank - 1;
        this.pos = new int[rank];
        this.delta = new int[rank];
        this.element = element;
        if (strides == null) {
            offset = 0;
            this.stride = new int[rank];
            int s = isize;
            int j = this.endrank;
            while (j >= 0) {
                this.stride[j] = s;
                s *= shape[j];
                --j;
            }
        } else {
            this.stride = (int[])strides.clone();
        }
        int j = this.endrank;
        while (j >= 0) {
            int t = this.stride[j];
            offset += t * this.start[j];
            this.stride[j] = t *= this.step[j];
            int s = this.sshape[j];
            if (!this.zero) {
                this.zero = s == 0;
            }
            this.delta[j] = s * t;
            --j;
        }
        this.nstart = offset;
    }

    @Override
    void calcGap() {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean hasNext() {
        if (this.zero) {
            return false;
        }
        j = this.endrank;
        if (j >= 0) ** GOTO lbl16
        this.index += this.istep;
        return this.index < this.istep;
lbl-1000:
        // 1 sources

        {
            this.index += this.stride[j];
            s = this.step[j];
            p = this.pos[j] + s;
            if (s > 0 && p < this.stop[j] || s < 0 && p > this.stop[j]) {
                this.pos[j] = p;
                break;
            }
            this.pos[j] = this.start[j];
            this.index -= this.delta[j];
            --j;
lbl16:
            // 2 sources

            ** while (j >= 0)
        }
lbl17:
        // 2 sources

        return j >= 0;
    }

    @Override
    public int[] getPos() {
        return this.pos;
    }

    @Override
    public void reset() {
        System.arraycopy(this.start, 0, this.pos, 0, this.start.length);
        if (this.endrank >= 0) {
            int n = this.endrank;
            this.pos[n] = this.pos[n] - this.step[this.endrank];
            this.index = this.nstart - this.stride[this.endrank];
        } else {
            this.index = -this.istep;
        }
        this.index += this.element;
    }
}

