/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.CompoundIntegerDataset;
import org.eclipse.january.dataset.CompoundShortDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.FloatDataset;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.RGBDataset;
import org.eclipse.january.dataset.ShortDataset;
import org.junit.Assert;
import org.junit.Test;

public class RGBDatasetTest {
    @Test
    public void testConstructors() {
        int n = 250;
        Dataset r = DatasetFactory.createRange(IntegerDataset.class, (double)n);
        Dataset g = DatasetFactory.createRange(IntegerDataset.class, (double)1.0, (double)(n + 1), (double)1.0);
        Dataset b = DatasetFactory.createRange(IntegerDataset.class, (double)2.0, (double)(n + 2), (double)1.0);
        RGBDataset c = new RGBDataset(r, g, b);
        int i = 0;
        while (i < n) {
            Assert.assertEquals((long)i, (long)c.getRed(i));
            Assert.assertEquals((long)(i + 1), (long)c.getGreen(i));
            Assert.assertEquals((long)(i + 2), (long)c.getBlue(i));
            ++i;
        }
        c = new RGBDataset(g);
        i = 0;
        while (i < n) {
            Assert.assertEquals((long)(i + 1), (long)c.getRed(i));
            Assert.assertEquals((long)(i + 1), (long)c.getGreen(i));
            Assert.assertEquals((long)(i + 1), (long)c.getBlue(i));
            ++i;
        }
        r = r.cast(1);
        g = g.cast(1);
        b = b.cast(1);
        c = new RGBDataset((byte[])r.getBuffer(), (byte[])g.getBuffer(), (byte[])b.getBuffer(), new int[0]);
        i = 0;
        while (i < n) {
            Assert.assertEquals((long)i, (long)c.getRed(i));
            Assert.assertEquals((long)(i + 1), (long)c.getGreen(i));
            Assert.assertEquals((long)(i + 2), (long)c.getBlue(i));
            ++i;
        }
        CompoundDataset cc = DatasetFactory.createRange((int)2, CompoundIntegerDataset.class, (double)n);
        c = RGBDataset.createFromCompoundDataset((CompoundDataset)cc);
        int i2 = 0;
        while (i2 < n) {
            Assert.assertEquals((long)i2, (long)c.getRed(i2));
            Assert.assertEquals((long)i2, (long)c.getGreen(i2));
            Assert.assertEquals((long)i2, (long)c.getBlue(i2));
            ++i2;
        }
        cc = DatasetFactory.createRange((int)4, CompoundIntegerDataset.class, (double)n);
        c = RGBDataset.createFromCompoundDataset((CompoundDataset)cc);
        i2 = 0;
        while (i2 < n) {
            Assert.assertEquals((long)i2, (long)c.getRed(i2));
            Assert.assertEquals((long)0L, (long)c.getGreen(i2));
            Assert.assertEquals((long)0L, (long)c.getBlue(i2));
            ++i2;
        }
    }

    @Test
    public void testConverters() {
        short[] sArray = new short[18];
        sArray[0] = 255;
        sArray[3] = 191;
        sArray[4] = 191;
        sArray[7] = 127;
        sArray[9] = 127;
        sArray[10] = 255;
        sArray[11] = 255;
        sArray[12] = 127;
        sArray[13] = 127;
        sArray[14] = 255;
        sArray[15] = 191;
        sArray[16] = 63;
        sArray[17] = 191;
        short[] rgbs = sArray;
        RGBDataset rgb = RGBDataset.createFromCompoundDataset((CompoundDataset)new CompoundShortDataset(3, rgbs, new int[]{6}));
        ShortDataset g = new ShortDataset(new short[]{76, 169, 74, 216, 141, 115}, new int[]{6});
        TestUtils.assertDatasetEquals((Dataset)g, (Dataset)rgb.createGreyDataset(2), (double)1.0, (double)1.0);
        short[] sArray2 = new short[6];
        sArray2[1] = 60;
        sArray2[2] = 120;
        sArray2[3] = 180;
        sArray2[4] = 240;
        sArray2[5] = 300;
        ShortDataset h = new ShortDataset(sArray2, new int[]{6});
        FloatDataset v = new FloatDataset(new float[]{1.0f, 0.75f, 0.5f, 1.0f, 1.0f, 0.75f}, new int[]{6});
        DoubleDataset s = new DoubleDataset(new double[]{1.0, 1.0, 1.0, 0.5, 0.5, 0.667}, new int[]{6});
        RGBDataset a = RGBDataset.createFromHSV((Dataset)h, (Dataset)s, (Dataset)v);
        TestUtils.assertDatasetEquals((Dataset)rgb, (Dataset)a, (double)1.0, (double)1.0);
        h.isubtract((Object)360);
        a = RGBDataset.createFromHSV((Dataset)h, (Dataset)s, (Dataset)v);
        TestUtils.assertDatasetEquals((Dataset)rgb, (Dataset)a, (double)1.0, (double)1.0);
        FloatDataset l = new FloatDataset(new float[]{0.5f, 0.375f, 0.25f, 0.75f, 0.75f, 0.5f}, new int[]{6});
        s = new DoubleDataset(new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 0.5}, new int[]{6});
        a = RGBDataset.createFromHSL((Dataset)h, (Dataset)s, (Dataset)l);
        TestUtils.assertDatasetEquals((Dataset)rgb, (Dataset)a, (double)1.0, (double)1.0);
        h.iadd((Object)360);
        a = RGBDataset.createFromHSL((Dataset)h, (Dataset)s, (Dataset)l);
        TestUtils.assertDatasetEquals((Dataset)rgb, (Dataset)a, (double)1.0, (double)1.0);
    }
}

