/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.math3.complex.Complex;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.Operations;
import org.eclipse.january.dataset.UnaryOperation;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class UnaryOperationTest {
    private UnaryOperation operation;
    private Object[] expected;
    private Object[][] operands;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{Operations.Negation.class, new Object[][]{{false, 1L}, {true, 0L}, {false, -1L}, {0L, 0L}, {-1L, 1L}, {1L, -1L}, {2L, -2L}, {0.0, 0.0}, {-1.0, 1.0}, {1.0, -1.0}, {2.0, -2.0}, {new Complex(0.0), 0.0, 0.0}, {new Complex(1.0), -1.0, 0.0}, {new Complex(-1.0), 1.0, 0.0}, {new Complex(2.0), -2.0, 0.0}, {new Complex(0.0, 0.0), 0.0, 0.0}, {new Complex(1.0, 1.0), -1.0, -1.0}, {new Complex(-1.0, -1.0), 1.0, 1.0}, {new Complex(2.0, -2.0), -2.0, 2.0}}}});
    }

    public UnaryOperationTest(Class<UnaryOperation> opClass, Object[][] values) throws Exception {
        this.operation = opClass.newInstance();
        int l = values.length;
        this.expected = new Object[l];
        this.operands = new Object[l][2];
        int i = 0;
        while (i < l) {
            Object[] o = values[i];
            this.expected[i] = o[0];
            this.operands[i] = Arrays.copyOfRange(o, 1, o.length);
            ++i;
        }
    }

    @Test
    public void testOp() {
        int i = 0;
        int imax = this.operands.length;
        while (i < imax) {
            Object[] vs = this.operands[i];
            Object ex = this.expected[i];
            String s = String.valueOf(this.toString()) + Arrays.toString(vs);
            if (ex instanceof Boolean) {
                Assert.assertEquals((String)s, (Object)ex, (Object)this.operation.booleanOperate(((Long)vs[0]).longValue()));
            } else if (ex instanceof Long) {
                Assert.assertEquals((String)s, (Object)ex, (Object)this.operation.longOperate(((Long)vs[0]).longValue()));
            } else if (ex instanceof Double) {
                TestUtils.assertEquals((String)s, (double)((Double)ex), (double)this.operation.doubleOperate(((Double)vs[0]).doubleValue()));
            } else if (ex instanceof Complex) {
                Complex cz = (Complex)ex;
                double[] cpx = new double[2];
                this.operation.complexOperate(cpx, ((Double)vs[0]).doubleValue(), ((Double)vs[1]).doubleValue());
                TestUtils.assertEquals((String)(String.valueOf(s) + ": real"), (double)cz.getReal(), (double)cpx[0], (double)1.0E-14, (double)7.0E-17);
                TestUtils.assertEquals((String)(String.valueOf(s) + ": imag"), (double)cz.getImaginary(), (double)cpx[1]);
            }
            ++i;
        }
    }

    public String toString() {
        return "Test of operation (" + this.operation + ") failed with " + Arrays.deepToString((Object[])this.operands);
    }
}

