/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.dataset.Slice;
import org.junit.Assert;
import org.junit.Test;

public class SliceTest {
    @Test
    public void testSlice() {
        Slice sl = new Slice();
        Assert.assertEquals((Object)":", (Object)sl.toString());
        sl = new Slice(Integer.valueOf(12));
        Assert.assertEquals((Object)":12", (Object)sl.toString());
        sl = new Slice(Integer.valueOf(1), Integer.valueOf(12));
        Assert.assertEquals((Object)"1:12", (Object)sl.toString());
        sl = new Slice(Integer.valueOf(0), Integer.valueOf(12));
        Assert.assertEquals((Object)":12", (Object)sl.toString());
        sl = new Slice(null, Integer.valueOf(12));
        Assert.assertEquals((Object)":12", (Object)sl.toString());
        sl = new Slice(Integer.valueOf(11), Integer.valueOf(12));
        Assert.assertEquals((Object)"11", (Object)sl.toString());
        sl = new Slice(Integer.valueOf(1), Integer.valueOf(12), Integer.valueOf(3));
        Assert.assertEquals((Object)"1:12:3", (Object)sl.toString());
        sl = new Slice(Integer.valueOf(11), Integer.valueOf(12), Integer.valueOf(3));
        Assert.assertEquals((Object)"11", (Object)sl.toString());
        sl = new Slice(Integer.valueOf(0), Integer.valueOf(12), Integer.valueOf(3));
        Assert.assertEquals((Object)":12:3", (Object)sl.toString());
        sl = new Slice(Integer.valueOf(1), Integer.valueOf(12)).setLength(12);
        Assert.assertEquals((Object)"1:", (Object)sl.toString());
        sl = new Slice(Integer.valueOf(1), null).setLength(12);
        Assert.assertEquals((Object)"1:", (Object)sl.toString());
        sl = new Slice(Integer.valueOf(0), Integer.valueOf(12)).setLength(12);
        Assert.assertEquals((Object)":", (Object)sl.toString());
        sl = new Slice(Integer.valueOf(1), Integer.valueOf(12), Integer.valueOf(3)).setLength(12);
        Assert.assertEquals((Object)"1::3", (Object)sl.toString());
        sl = new Slice(Integer.valueOf(0), Integer.valueOf(12), Integer.valueOf(3)).setLength(12);
        Assert.assertEquals((Object)"::3", (Object)sl.toString());
        sl = new Slice(null, null, Integer.valueOf(3)).setLength(12);
        Assert.assertEquals((Object)"::3", (Object)sl.toString());
        sl = new Slice(Integer.valueOf(11), Integer.valueOf(12));
        Assert.assertEquals((Object)"11", (Object)sl.toString());
        sl = new Slice(Integer.valueOf(0), Integer.valueOf(1));
        Assert.assertEquals((Object)"0", (Object)sl.toString());
        sl = new Slice(Integer.valueOf(1));
        Assert.assertEquals((Object)"0", (Object)sl.toString());
    }

    @Test
    public void testSliceSteps() {
        Slice sl = new Slice(null, null, Integer.valueOf(3)).setLength(1);
        Assert.assertEquals((long)1L, (long)sl.getNumSteps());
        sl = new Slice(null, null, Integer.valueOf(3)).setLength(2);
        Assert.assertEquals((long)1L, (long)sl.getNumSteps());
        sl = new Slice(null, null, Integer.valueOf(3)).setLength(3);
        Assert.assertEquals((long)1L, (long)sl.getNumSteps());
        sl = new Slice(null, null, Integer.valueOf(3)).setLength(4);
        Assert.assertEquals((long)2L, (long)sl.getNumSteps());
        sl = new Slice(null, null, Integer.valueOf(3)).setLength(5);
        Assert.assertEquals((long)2L, (long)sl.getNumSteps());
        sl = new Slice(null, null, Integer.valueOf(3)).setLength(6);
        Assert.assertEquals((long)2L, (long)sl.getNumSteps());
        sl = new Slice(null, null, Integer.valueOf(3)).setLength(7);
        Assert.assertEquals((long)3L, (long)sl.getNumSteps());
        sl = new Slice(null, null, Integer.valueOf(3)).setLength(8);
        Assert.assertEquals((long)3L, (long)sl.getNumSteps());
        sl = new Slice(null, null, Integer.valueOf(3)).setLength(9);
        Assert.assertEquals((long)3L, (long)sl.getNumSteps());
        sl = new Slice().setLength(12);
        Assert.assertEquals((long)12L, (long)sl.getNumSteps());
        sl = new Slice(null, null, Integer.valueOf(2)).setLength(12);
        Assert.assertEquals((long)6L, (long)sl.getNumSteps());
        sl = new Slice(Integer.valueOf(1), null).setLength(12);
        Assert.assertEquals((long)11L, (long)sl.getNumSteps());
        sl = new Slice(Integer.valueOf(1), null, Integer.valueOf(2)).setLength(12);
        Assert.assertEquals((long)6L, (long)sl.getNumSteps());
        sl = new Slice(Integer.valueOf(1), null, Integer.valueOf(-2)).setLength(12);
        Assert.assertEquals((long)1L, (long)sl.getNumSteps());
        sl = new Slice(null, null, Integer.valueOf(-1)).setLength(12);
        Assert.assertEquals((long)12L, (long)sl.getNumSteps());
        sl = new Slice(null, null, Integer.valueOf(-2)).setLength(12);
        Assert.assertEquals((long)6L, (long)sl.getNumSteps());
        sl = new Slice(Integer.valueOf(6), null, Integer.valueOf(-2)).setLength(12);
        Assert.assertEquals((long)4L, (long)sl.getNumSteps());
        sl = new Slice(Integer.valueOf(6), Integer.valueOf(1), Integer.valueOf(-2)).setLength(12);
        Assert.assertEquals((long)3L, (long)sl.getNumSteps());
        sl = new Slice(Integer.valueOf(6), Integer.valueOf(0), Integer.valueOf(-2)).setLength(12);
        Assert.assertEquals((long)3L, (long)sl.getNumSteps());
        try {
            sl = new Slice();
            sl.getNumSteps();
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalStateException");
        }
        sl = new Slice(Integer.valueOf(12));
        Assert.assertEquals((long)12L, (long)sl.getNumSteps());
        sl = new Slice(Integer.valueOf(1), Integer.valueOf(12));
        Assert.assertEquals((long)11L, (long)sl.getNumSteps());
        sl = new Slice(Integer.valueOf(12), Integer.valueOf(1));
        Assert.assertEquals((long)0L, (long)sl.getNumSteps());
        sl = new Slice(Integer.valueOf(1), Integer.valueOf(12), Integer.valueOf(2));
        Assert.assertEquals((long)6L, (long)sl.getNumSteps());
        sl = new Slice(Integer.valueOf(1), Integer.valueOf(12), Integer.valueOf(12));
        Assert.assertEquals((long)1L, (long)sl.getNumSteps());
        sl = new Slice(Integer.valueOf(12), Integer.valueOf(1), Integer.valueOf(-1));
        Assert.assertEquals((long)11L, (long)sl.getNumSteps());
        sl = new Slice(Integer.valueOf(1), Integer.valueOf(12), Integer.valueOf(-1));
        Assert.assertEquals((long)0L, (long)sl.getNumSteps());
        sl = new Slice(Integer.valueOf(12), Integer.valueOf(1), Integer.valueOf(-2));
        Assert.assertEquals((long)6L, (long)sl.getNumSteps());
        sl = new Slice(Integer.valueOf(12), Integer.valueOf(1), Integer.valueOf(-12));
        Assert.assertEquals((long)1L, (long)sl.getNumSteps());
        sl = new Slice(null, Integer.valueOf(11), Integer.valueOf(1));
        Assert.assertEquals((long)11L, (long)sl.getNumSteps());
        try {
            sl = new Slice(Integer.valueOf(11), null, Integer.valueOf(-1));
            sl.getNumSteps();
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalStateException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalStateException");
        }
        sl = new Slice(null, null, Integer.valueOf(15)).setLength(4096);
        Assert.assertEquals((long)274L, (long)sl.getNumSteps());
    }

    @Test
    public void testSliceEndPoints() {
        Slice sl = new Slice(null, null, Integer.valueOf(1)).setLength(1);
        Assert.assertEquals((long)1L, (long)sl.getNumSteps());
        sl = new Slice(null, null, Integer.valueOf(1)).setLength(5);
        Assert.assertEquals((long)5L, (long)sl.getNumSteps());
        sl = new Slice(null, Integer.valueOf(5), Integer.valueOf(1)).setLength(5);
        Assert.assertEquals((long)5L, (long)sl.getNumSteps());
        sl = new Slice(Integer.valueOf(0), null, Integer.valueOf(1)).setLength(5);
        Assert.assertEquals((long)5L, (long)sl.getNumSteps());
        sl = new Slice(Integer.valueOf(0), Integer.valueOf(5), Integer.valueOf(1)).setLength(5);
        Assert.assertEquals((long)5L, (long)sl.getNumSteps());
        sl = new Slice(Integer.valueOf(0), Integer.valueOf(5), Integer.valueOf(-1)).setLength(5);
        Assert.assertEquals((long)0L, (long)sl.getNumSteps());
        sl = new Slice(null, null, Integer.valueOf(-1)).setLength(1);
        Assert.assertEquals((long)1L, (long)sl.getNumSteps());
        sl = new Slice(null, null, Integer.valueOf(-1)).setLength(5);
        Assert.assertEquals((long)5L, (long)sl.getNumSteps());
        sl = new Slice(null, Integer.valueOf(-1), Integer.valueOf(-1)).setLength(5);
        Assert.assertEquals((long)5L, (long)sl.getNumSteps());
        sl = new Slice(Integer.valueOf(4), null, Integer.valueOf(-1)).setLength(5);
        Assert.assertEquals((long)5L, (long)sl.getNumSteps());
        sl = new Slice(Integer.valueOf(4), Integer.valueOf(-1), Integer.valueOf(-1)).setLength(5);
        Assert.assertEquals((long)5L, (long)sl.getNumSteps());
        sl = new Slice(Integer.valueOf(4), Integer.valueOf(-1), Integer.valueOf(1)).setLength(5);
        Assert.assertEquals((long)0L, (long)sl.getNumSteps());
    }

    @Test
    public void testGetter() {
        Slice sl = new Slice().setLength(12);
        Assert.assertEquals(null, (Object)sl.getStart());
        Assert.assertEquals(null, (Object)sl.getStop());
        Assert.assertEquals((long)1L, (long)sl.getStep());
        Assert.assertEquals((long)12L, (long)sl.getLength());
        sl = new Slice(Integer.valueOf(10)).setLength(12);
        Assert.assertEquals(null, (Object)sl.getStart());
        Assert.assertEquals((long)10L, (long)sl.getStop().intValue());
        Assert.assertEquals((long)1L, (long)sl.getStep());
        Assert.assertEquals((long)12L, (long)sl.getLength());
    }

    @Test
    public void testSetter() {
        Slice sl = new Slice().setLength(12);
        sl.setStart(Integer.valueOf(1));
        Assert.assertEquals((long)1L, (long)sl.getStart().intValue());
        sl.setStop(Integer.valueOf(10));
        Assert.assertEquals((long)10L, (long)sl.getStop().intValue());
        sl.setStep(2);
        Assert.assertEquals((long)2L, (long)sl.getStep());
        sl.setLength(11);
        Assert.assertEquals((long)11L, (long)sl.getLength());
        sl = new Slice().setLength(12);
        sl.setStart(Integer.valueOf(3));
        sl.setStop(Integer.valueOf(10));
        try {
            sl.setLength(9);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        try {
            sl.setStart(Integer.valueOf(11));
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        sl = new Slice().setLength(12);
        sl.setStart(Integer.valueOf(3));
        sl.setStop(Integer.valueOf(10));
        try {
            sl.setLength(9);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        try {
            sl.setStart(Integer.valueOf(11));
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        try {
            sl.setStop(Integer.valueOf(0));
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        sl = new Slice().setLength(12);
        sl.setStep(-2);
        sl.setStart(Integer.valueOf(10));
        sl.setStop(Integer.valueOf(3));
        try {
            sl.setLength(9);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        try {
            sl.setStart(Integer.valueOf(2));
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        try {
            sl.setStop(Integer.valueOf(10));
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        try {
            sl.setStep(0);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        sl = new Slice(Integer.valueOf(10)).setLength(12);
        Assert.assertEquals(null, (Object)sl.getStart());
        Assert.assertEquals((long)10L, (long)sl.getStop().intValue());
        Assert.assertEquals((long)1L, (long)sl.getStep());
        Assert.assertEquals((long)12L, (long)sl.getLength());
    }

    @Test
    public void testSliceEnd() {
        Slice sl = new Slice().setLength(12);
        Assert.assertEquals((long)11L, (long)sl.getEnd());
        sl = new Slice(null, null, Integer.valueOf(2)).setLength(12);
        Assert.assertEquals((long)10L, (long)sl.getEnd());
        sl = new Slice(Integer.valueOf(1), null).setLength(12);
        Assert.assertEquals((long)11L, (long)sl.getEnd());
        sl = new Slice(Integer.valueOf(1), null, Integer.valueOf(2)).setLength(12);
        Assert.assertEquals((long)11L, (long)sl.getEnd());
        sl = new Slice(Integer.valueOf(1), null, Integer.valueOf(-2)).setLength(12);
        Assert.assertEquals((long)1L, (long)sl.getEnd());
        sl = new Slice(null, null, Integer.valueOf(-1)).setLength(12);
        Assert.assertEquals((long)0L, (long)sl.getEnd());
        sl = new Slice(null, null, Integer.valueOf(-2)).setLength(12);
        Assert.assertEquals((long)1L, (long)sl.getEnd());
        sl = new Slice(Integer.valueOf(12));
        Assert.assertEquals((long)11L, (long)sl.getEnd());
        sl = new Slice(Integer.valueOf(1), Integer.valueOf(12));
        Assert.assertEquals((long)11L, (long)sl.getEnd());
        try {
            sl = new Slice(Integer.valueOf(12), Integer.valueOf(1));
            sl.getEnd();
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalStateException");
        }
        sl = new Slice(Integer.valueOf(1), Integer.valueOf(12), Integer.valueOf(2));
        Assert.assertEquals((long)11L, (long)sl.getEnd());
        sl = new Slice(Integer.valueOf(1), Integer.valueOf(12), Integer.valueOf(12));
        Assert.assertEquals((long)1L, (long)sl.getEnd());
        sl = new Slice(Integer.valueOf(12), Integer.valueOf(1), Integer.valueOf(-1));
        Assert.assertEquals((long)2L, (long)sl.getEnd());
        sl = new Slice(Integer.valueOf(12), Integer.valueOf(1), Integer.valueOf(-2));
        Assert.assertEquals((long)2L, (long)sl.getEnd());
        sl = new Slice(Integer.valueOf(12), Integer.valueOf(1), Integer.valueOf(-12));
        Assert.assertEquals((long)12L, (long)sl.getEnd());
        sl = new Slice(null, Integer.valueOf(12), Integer.valueOf(2));
        Assert.assertEquals((long)10L, (long)sl.getEnd());
        try {
            sl = new Slice(null, Integer.valueOf(12), Integer.valueOf(-2));
            sl.getEnd();
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalStateException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalStateException");
        }
        try {
            sl = new Slice(null, null, Integer.valueOf(-2));
            sl.getEnd();
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalStateException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalStateException");
        }
    }

    @Test
    public void testFlip() {
        Slice sl = new Slice().flip();
        Assert.assertEquals((Object)"::-1", (Object)sl.toString());
        Assert.assertEquals((Object)":", (Object)sl.flip().toString());
        sl = new Slice(Integer.valueOf(12)).flip();
        Assert.assertEquals((Object)"11::-1", (Object)sl.toString());
        Assert.assertEquals((Object)":12", (Object)sl.flip().toString());
        sl = new Slice(Integer.valueOf(1), Integer.valueOf(12)).flip();
        Assert.assertEquals((Object)"11:0:-1", (Object)sl.toString());
        Assert.assertEquals((Object)"1:12", (Object)sl.flip().toString());
        sl = new Slice(Integer.valueOf(0), Integer.valueOf(12)).flip();
        Assert.assertEquals((Object)"11::-1", (Object)sl.toString());
        Assert.assertEquals((Object)":12", (Object)sl.flip().toString());
        sl = new Slice(null, Integer.valueOf(12)).flip();
        Assert.assertEquals((Object)"11::-1", (Object)sl.toString());
        Assert.assertEquals((Object)":12", (Object)sl.flip().toString());
        sl = new Slice(Integer.valueOf(11), Integer.valueOf(12)).flip();
        Assert.assertEquals((Object)"11", (Object)sl.toString());
        Assert.assertEquals((Object)"11", (Object)sl.flip().toString());
        sl = new Slice(Integer.valueOf(1), Integer.valueOf(12), Integer.valueOf(3)).flip();
        Assert.assertEquals((Object)"10:-2:-3", (Object)sl.toString());
        Assert.assertEquals((Object)"1:13:3", (Object)sl.flip().toString());
        sl = new Slice(Integer.valueOf(11), Integer.valueOf(12), Integer.valueOf(3)).flip();
        Assert.assertEquals((Object)"11", (Object)sl.toString());
        Assert.assertEquals((Object)"11", (Object)sl.flip().toString());
        sl = new Slice().setLength(12);
        sl.flip();
        Assert.assertEquals(null, (Object)sl.getStart());
        Assert.assertEquals(null, (Object)sl.getStop());
        Assert.assertEquals((long)-1L, (long)sl.getStep());
        Assert.assertEquals((long)12L, (long)sl.getLength());
        sl = new Slice(Integer.valueOf(10)).setLength(12);
        sl.flip();
        Assert.assertEquals((long)9L, (long)sl.getStart().intValue());
        Assert.assertEquals(null, (Object)sl.getStop());
        Assert.assertEquals((long)-1L, (long)sl.getStep());
        Assert.assertEquals((long)12L, (long)sl.getLength());
    }

    @Test
    public void testConverters() {
        int[] start = new int[1];
        int[] stop = new int[1];
        int[] step = new int[1];
        int[] shape = new int[]{12};
        Slice.convertFromSlice((Slice[])new Slice[1], (int[])shape, (int[])start, (int[])stop, (int[])step);
        Assert.assertEquals((long)0L, (long)start[0]);
        Assert.assertEquals((long)12L, (long)stop[0]);
        Assert.assertEquals((long)1L, (long)step[0]);
        Slice.convertFromSlice((Slice[])new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(11), Integer.valueOf(2)).setLength(12)}, (int[])shape, (int[])start, (int[])stop, (int[])step);
        Assert.assertEquals((long)1L, (long)start[0]);
        Assert.assertEquals((long)11L, (long)stop[0]);
        Assert.assertEquals((long)2L, (long)step[0]);
        Slice.convertFromSlice((Slice[])new Slice[]{new Slice().setLength(12)}, (int[])shape, (int[])start, (int[])stop, (int[])step);
        Assert.assertEquals((long)0L, (long)start[0]);
        Assert.assertEquals((long)12L, (long)stop[0]);
        Assert.assertEquals((long)1L, (long)step[0]);
        Slice[] sl = Slice.convertToSlice((int[])start, (int[])stop, (int[])step);
        Assert.assertEquals((long)1L, (long)sl.length);
        Assert.assertEquals((long)0L, (long)sl[0].getStart().intValue());
        Assert.assertEquals((long)12L, (long)sl[0].getStop().intValue());
        Assert.assertEquals((long)1L, (long)sl[0].getStep());
        sl = Slice.convertFromString((String)"[:,:,:,:]");
        Assert.assertEquals((long)4L, (long)sl.length);
        Assert.assertEquals((long)0L, (long)sl[0].getStart().intValue());
        Assert.assertEquals((long)0L, (long)sl[1].getStart().intValue());
        Assert.assertEquals((long)0L, (long)sl[2].getStart().intValue());
        Assert.assertEquals((long)0L, (long)sl[3].getStart().intValue());
        Assert.assertEquals(null, (Object)sl[0].getStop());
        Assert.assertEquals(null, (Object)sl[1].getStop());
        Assert.assertEquals(null, (Object)sl[2].getStop());
        Assert.assertEquals(null, (Object)sl[3].getStop());
        Assert.assertEquals((long)1L, (long)sl[0].getStep());
        Assert.assertEquals((long)1L, (long)sl[1].getStep());
        Assert.assertEquals((long)1L, (long)sl[2].getStep());
        Assert.assertEquals((long)1L, (long)sl[3].getStep());
        sl = Slice.convertFromString((String)"[::]");
        Assert.assertEquals((long)0L, (long)sl[0].getStart().intValue());
        Assert.assertEquals(null, (Object)sl[0].getStop());
        Assert.assertEquals((long)1L, (long)sl[0].getStep());
        sl = Slice.convertFromString((String)"[1::]");
        Assert.assertEquals((long)1L, (long)sl[0].getStart().intValue());
        Assert.assertEquals(null, (Object)sl[0].getStop());
        Assert.assertEquals((long)1L, (long)sl[0].getStep());
        sl = Slice.convertFromString((String)"[:3:]");
        Assert.assertEquals((long)0L, (long)sl[0].getStart().intValue());
        Assert.assertEquals((long)3L, (long)sl[0].getStop().intValue());
        Assert.assertEquals((long)1L, (long)sl[0].getStep());
        sl = Slice.convertFromString((String)"[::-1]");
        Assert.assertEquals((long)0L, (long)sl[0].getStart().intValue());
        Assert.assertEquals(null, (Object)sl[0].getStop());
        Assert.assertEquals((long)-1L, (long)sl[0].getStep());
        sl = Slice.convertFromString((String)"[10:2:-2]");
        Assert.assertEquals((long)10L, (long)sl[0].getStart().intValue());
        Assert.assertEquals((long)2L, (long)sl[0].getStop().intValue());
        Assert.assertEquals((long)-2L, (long)sl[0].getStep());
    }

    @Test
    public void testShifts() {
        Slice sl = new Slice().setLength(12);
        sl.setStop(Integer.valueOf(2));
        Assert.assertEquals((long)2L, (long)sl.getNumSteps());
        Assert.assertFalse((boolean)sl.setPosition(5));
        Assert.assertEquals((long)5L, (long)sl.getStart().intValue());
        Assert.assertEquals((long)7L, (long)sl.getStop().intValue());
        sl.setStart(Integer.valueOf(5));
        Assert.assertEquals((long)5L, (long)sl.getStart().intValue());
        Assert.assertTrue((boolean)sl.setPosition(11));
    }

    @Test
    public void testPos() {
        Slice sl = new Slice(Integer.valueOf(0), Integer.valueOf(10), Integer.valueOf(1));
        Assert.assertEquals((long)0L, (long)sl.getPosition(0));
        Assert.assertEquals((long)5L, (long)sl.getPosition(5));
        try {
            sl.getPosition(-1);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        try {
            sl.getPosition(10);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        sl = new Slice(Integer.valueOf(5), Integer.valueOf(2), Integer.valueOf(-1));
        Assert.assertEquals((long)5L, (long)sl.getPosition(0));
        Assert.assertEquals((long)3L, (long)sl.getPosition(2));
        try {
            sl.getPosition(3);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        sl = new Slice(null, null, Integer.valueOf(1)).setLength(12);
        Assert.assertEquals((long)0L, (long)sl.getPosition(0));
        Assert.assertEquals((long)3L, (long)sl.getPosition(3));
        try {
            sl.getPosition(12);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        sl = new Slice(null, null, Integer.valueOf(-1)).setLength(12);
        Assert.assertEquals((long)11L, (long)sl.getPosition(0));
        Assert.assertEquals((long)8L, (long)sl.getPosition(3));
        try {
            sl.getPosition(12);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        sl = new Slice(null, null, Integer.valueOf(-2)).setLength(12);
        Assert.assertEquals((long)11L, (long)sl.getPosition(0));
        Assert.assertEquals((long)5L, (long)sl.getPosition(3));
        Assert.assertEquals((long)1L, (long)sl.getPosition(5));
        try {
            sl.getPosition(6);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        sl = new Slice(Integer.valueOf(6), null, Integer.valueOf(-2)).setLength(12);
        Assert.assertEquals((long)6L, (long)sl.getPosition(0));
        Assert.assertEquals((long)0L, (long)sl.getPosition(3));
        try {
            sl.getPosition(4);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        sl = new Slice(Integer.valueOf(6), Integer.valueOf(1), Integer.valueOf(-2)).setLength(12);
        Assert.assertEquals((long)6L, (long)sl.getPosition(0));
        Assert.assertEquals((long)2L, (long)sl.getPosition(2));
        try {
            sl.getPosition(3);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
        sl = new Slice(Integer.valueOf(6), Integer.valueOf(0), Integer.valueOf(-2)).setLength(12);
        Assert.assertEquals((long)6L, (long)sl.getPosition(0));
        Assert.assertEquals((long)2L, (long)sl.getPosition(2));
        try {
            sl.getPosition(3);
            Assert.fail((String)"No exception thrown");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Exception e) {
            Assert.fail((String)"Wrong exception type passed, this should give an IllegalArgumentException");
        }
    }

    @Test
    public void testSetZeroLength() {
        Slice s = new Slice(Integer.valueOf(4), Integer.valueOf(5));
        s.setLength(9);
        s.setStart(Integer.valueOf(0));
        s.setStop(Integer.valueOf(0));
        s.setLength(0);
        Assert.assertEquals((long)0L, (long)s.getNumSteps());
    }
}

