/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import org.eclipse.january.dataset.ByteDataset;
import org.eclipse.january.dataset.CompoundByteDataset;
import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.SliceIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RGBByteDataset
extends CompoundByteDataset
implements Cloneable {
    private static final long serialVersionUID = -6891075135217265625L;
    private static final Logger logger = LoggerFactory.getLogger(RGBByteDataset.class);
    private static final int ISIZE = 3;
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 255;
    private static final double Wr = 0.299;
    private static final double Wg = 0.587;
    private static final double Wb = 0.114;

    public RGBByteDataset() {
        super(3);
    }

    public RGBByteDataset(int ... shape) {
        super(3, shape);
    }

    public RGBByteDataset(byte[] data, int ... shape) {
        super(3, data, shape);
    }

    public RGBByteDataset(RGBByteDataset dataset) {
        super(dataset);
    }

    @Override
    public RGBByteDataset clone() {
        return new RGBByteDataset(this);
    }

    public RGBByteDataset(int[] redData, int[] greenData, int[] blueData, int ... shape) {
        int dsize = redData.length > greenData.length ? greenData.length : redData.length;
        int n = dsize = dsize > blueData.length ? blueData.length : dsize;
        if (shape == null || shape.length == 0) {
            shape = new int[]{dsize};
        }
        this.isize = 3;
        this.size = ShapeUtils.calcSize(shape);
        if (this.size != dsize) {
            logger.error("Shape is not compatible with size of data array");
            throw new IllegalArgumentException("Shape is not compatible with size of data array");
        }
        this.shape = (int[])shape.clone();
        try {
            this.data = this.createArray(this.size);
            this.odata = this.data;
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
        int i = 0;
        int n2 = 0;
        while (i < this.size) {
            this.data[n2++] = (byte)redData[i];
            this.data[n2++] = (byte)greenData[i];
            this.data[n2++] = (byte)blueData[i];
            ++i;
        }
    }

    public RGBByteDataset(short[] redData, short[] greenData, short[] blueData, int ... shape) {
        int dsize = redData.length > greenData.length ? greenData.length : redData.length;
        int n = dsize = dsize > blueData.length ? blueData.length : dsize;
        if (shape == null || shape.length == 0) {
            shape = new int[]{dsize};
        }
        this.isize = 3;
        this.size = ShapeUtils.calcSize(shape);
        if (this.size != dsize) {
            logger.error("Shape is not compatible with size of data array");
            throw new IllegalArgumentException("Shape is not compatible with size of data array");
        }
        this.shape = (int[])shape.clone();
        try {
            this.data = this.createArray(this.size);
            this.odata = this.data;
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
        int i = 0;
        int n2 = 0;
        while (i < this.size) {
            this.data[n2++] = (byte)redData[i];
            this.data[n2++] = (byte)greenData[i];
            this.data[n2++] = (byte)blueData[i];
            ++i;
        }
    }

    public RGBByteDataset(byte[] redData, byte[] greenData, byte[] blueData, int ... shape) {
        int dsize = redData.length > greenData.length ? greenData.length : redData.length;
        int n = dsize = dsize > blueData.length ? blueData.length : dsize;
        if (shape == null || shape.length == 0) {
            shape = new int[]{dsize};
        }
        this.isize = 3;
        this.size = ShapeUtils.calcSize(shape);
        if (this.size != dsize) {
            logger.error("Shape is not compatible with size of data array");
            throw new IllegalArgumentException("Shape is not compatible with size of data array");
        }
        this.shape = (int[])shape.clone();
        try {
            this.data = this.createArray(this.size);
            this.odata = this.data;
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
        int i = 0;
        int n2 = 0;
        while (i < this.size) {
            this.data[n2++] = redData[i];
            this.data[n2++] = greenData[i];
            this.data[n2++] = blueData[i];
            ++i;
        }
    }

    public RGBByteDataset(Dataset red, Dataset green, Dataset blue) {
        super(3, red.getShapeRef());
        red.checkCompatibility(green);
        red.checkCompatibility(blue);
        if (red.max(new boolean[0]).doubleValue() > 255.0 || red.min(new boolean[0]).doubleValue() < 0.0 || green.max(new boolean[0]).doubleValue() > 255.0 || green.min(new boolean[0]).doubleValue() < 0.0 || blue.max(new boolean[0]).doubleValue() > 255.0 || blue.min(new boolean[0]).doubleValue() < 0.0) {
            logger.warn("Some values are out of range and will be truncated");
        }
        IndexIterator riter = red.getIterator();
        IndexIterator giter = green.getIterator();
        IndexIterator biter = blue.getIterator();
        int i = 0;
        while (riter.hasNext() && giter.hasNext() && biter.hasNext()) {
            this.data[i++] = (byte)red.getElementLongAbs(riter.index);
            this.data[i++] = (byte)green.getElementLongAbs(giter.index);
            this.data[i++] = (byte)blue.getElementLongAbs(biter.index);
        }
    }

    public RGBByteDataset(Dataset grey) {
        super(3, grey.getShapeRef());
        IndexIterator giter = grey.getIterator();
        int i = 0;
        while (giter.hasNext()) {
            byte g = (byte)grey.getElementLongAbs(giter.index);
            this.data[i++] = g;
            this.data[i++] = g;
            this.data[i++] = g;
        }
    }

    public RGBByteDataset(CompoundDataset colour) {
        super(3, colour.getShapeRef());
        if (colour.getElementsPerItem() != 3) {
            throw new IllegalArgumentException("Compound dataset must have three elements per item");
        }
        IndexIterator it = colour.getIterator();
        int i = 0;
        while (it.hasNext()) {
            this.data[i++] = (byte)colour.getElementLongAbs(it.index);
            this.data[i++] = (byte)colour.getElementLongAbs(it.index + 1);
            this.data[i++] = (byte)colour.getElementLongAbs(it.index + 2);
        }
    }

    public static RGBByteDataset createFromObject(Object obj) {
        CompoundByteDataset result = (CompoundByteDataset)DatasetUtils.createCompoundDataset((Dataset)ByteDataset.createFromObject(obj), 3);
        return new RGBByteDataset(result.data, result.shape);
    }

    public static RGBByteDataset createFromCompoundDataset(CompoundDataset a) {
        if (a instanceof RGBByteDataset) {
            return (RGBByteDataset)a;
        }
        int is = a.getElementsPerItem();
        if (is < 3) {
            return new RGBByteDataset((Dataset)a);
        }
        if (a instanceof CompoundByteDataset && is == 3) {
            return new RGBByteDataset((byte[])a.getBuffer(), a.getShapeRef());
        }
        RGBByteDataset rgb = new RGBByteDataset(a.getShapeRef());
        IndexIterator it = a.getIterator();
        int n = 0;
        while (it.hasNext()) {
            rgb.data[n++] = (byte)a.getElementLongAbs(it.index);
            rgb.data[n++] = (byte)a.getElementLongAbs(it.index + 1);
            rgb.data[n++] = (byte)a.getElementLongAbs(it.index + 2);
        }
        return rgb;
    }

    /*
     * Unable to fully structure code
     */
    public static RGBByteDataset createFromHSV(Dataset hue, Dataset saturation, Dataset value) {
        block3: {
            if (saturation != null && !hue.isCompatibleWith(saturation) || !hue.isCompatibleWith(value)) {
                throw new IllegalArgumentException("Hue, saturation and value datasets must have the same shape");
            }
            result = new RGBByteDataset(hue.getShapeRef());
            it = result.getIterator(true);
            pos = it.getPos();
            rgb = new byte[3];
            if (saturation != null) ** GOTO lbl15
            while (it.hasNext()) {
                RGBByteDataset.convertHSVToRGB(hue.getDouble(pos), 1.0, value.getDouble(pos), rgb);
                result.setAbs(it.index, rgb);
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                RGBByteDataset.convertHSVToRGB(hue.getDouble(pos), saturation.getDouble(pos), value.getDouble(pos), rgb);
                result.setAbs(it.index, rgb);
lbl15:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static RGBByteDataset createFromHSL(Dataset hue, Dataset saturation, Dataset lightness) {
        block3: {
            if (saturation != null && !hue.isCompatibleWith(saturation) || !hue.isCompatibleWith(lightness)) {
                throw new IllegalArgumentException("Hue, saturation and lightness datasets must have the same shape");
            }
            result = new RGBByteDataset(hue.getShapeRef());
            it = result.getIterator(true);
            pos = it.getPos();
            rgb = new byte[3];
            if (saturation != null) ** GOTO lbl15
            while (it.hasNext()) {
                RGBByteDataset.convertHSLToRGB(hue.getDouble(pos), 1.0, lightness.getDouble(pos), rgb);
                result.setAbs(it.index, rgb);
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                RGBByteDataset.convertHSLToRGB(hue.getDouble(pos), saturation.getDouble(pos), lightness.getDouble(pos), rgb);
                result.setAbs(it.index, rgb);
lbl15:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return result;
    }

    private static void convertHSVToRGB(double h, double s, double v, byte[] rgb) {
        double m = 255.0 * v;
        double chroma = s * m;
        m -= chroma;
        double hprime = h / 60.0;
        if (hprime < 0.0) {
            hprime += 6.0;
        }
        byte sx = (byte)(chroma * (1.0 - Math.abs(hprime % 2.0 - 1.0)) + m);
        byte sc = (byte)(chroma + m);
        byte sm = (byte)m;
        if (hprime < 1.0) {
            rgb[0] = sc;
            rgb[1] = sx;
            rgb[2] = sm;
        } else if (hprime < 2.0) {
            rgb[0] = sx;
            rgb[1] = sc;
            rgb[2] = sm;
        } else if (hprime < 3.0) {
            rgb[0] = sm;
            rgb[1] = sc;
            rgb[2] = sx;
        } else if (hprime < 4.0) {
            rgb[0] = sm;
            rgb[1] = sx;
            rgb[2] = sc;
        } else if (hprime < 5.0) {
            rgb[0] = sx;
            rgb[1] = sm;
            rgb[2] = sc;
        } else if (hprime < 6.0) {
            rgb[0] = sc;
            rgb[1] = sm;
            rgb[2] = sx;
        } else {
            rgb[0] = sm;
            rgb[1] = sm;
            rgb[2] = sm;
        }
    }

    private static void convertHSLToRGB(double h, double s, double l, byte[] rgb) {
        double m = l;
        double chroma = s * (1.0 - Math.abs(2.0 * m - 1.0));
        m -= chroma * 0.5;
        m *= 255.0;
        chroma *= 255.0;
        double hprime = h / 60.0;
        if (hprime < 0.0) {
            hprime += 6.0;
        }
        byte sx = (byte)(chroma * (1.0 - Math.abs(hprime % 2.0 - 1.0)) + m);
        byte sc = (byte)(chroma + m);
        byte sm = (byte)m;
        if (hprime < 1.0) {
            rgb[0] = sc;
            rgb[1] = sx;
            rgb[2] = sm;
        } else if (hprime < 2.0) {
            rgb[0] = sx;
            rgb[1] = sc;
            rgb[2] = sm;
        } else if (hprime < 3.0) {
            rgb[0] = sm;
            rgb[1] = sc;
            rgb[2] = sx;
        } else if (hprime < 4.0) {
            rgb[0] = sm;
            rgb[1] = sx;
            rgb[2] = sc;
        } else if (hprime < 5.0) {
            rgb[0] = sx;
            rgb[1] = sm;
            rgb[2] = sc;
        } else if (hprime < 6.0) {
            rgb[0] = sc;
            rgb[1] = sm;
            rgb[2] = sx;
        } else {
            rgb[0] = sm;
            rgb[1] = sm;
            rgb[2] = sm;
        }
    }

    @Override
    public RGBByteDataset getSlice(SliceIterator siter) {
        CompoundByteDataset base = super.getSlice(siter);
        RGBByteDataset slice = new RGBByteDataset();
        RGBByteDataset.copyToView(base, slice, false, false);
        slice.setData();
        return slice;
    }

    @Override
    public RGBByteDataset getView(boolean deepCopyMetadata) {
        RGBByteDataset view = new RGBByteDataset();
        RGBByteDataset.copyToView(this, view, true, deepCopyMetadata);
        view.setData();
        return view;
    }

    public byte getRed() {
        return this.data[this.getFirst1DIndex()];
    }

    public byte getRed(int i) {
        return this.data[this.get1DIndex(i)];
    }

    public byte getRed(int i, int j) {
        return this.data[this.get1DIndex(i, j)];
    }

    public byte getRed(int ... pos) {
        return this.data[this.get1DIndex(pos)];
    }

    public byte getGreen() {
        return this.data[this.getFirst1DIndex() + 1];
    }

    public byte getGreen(int i) {
        return this.data[this.get1DIndex(i) + 1];
    }

    public byte getGreen(int i, int j) {
        return this.data[this.get1DIndex(i, j) + 1];
    }

    public byte getGreen(int ... pos) {
        return this.data[this.get1DIndex(pos) + 1];
    }

    public byte getBlue() {
        return this.data[this.getFirst1DIndex() + 2];
    }

    public byte getBlue(int i) {
        return this.data[this.get1DIndex(i) + 2];
    }

    public byte getBlue(int i, int j) {
        return this.data[this.get1DIndex(i, j) + 2];
    }

    public byte getBlue(int ... pos) {
        return this.data[this.get1DIndex(pos) + 2];
    }

    public byte getRedAbs(int n) {
        return this.data[n * this.isize];
    }

    public byte getGreenAbs(int n) {
        return this.data[n * this.isize + 1];
    }

    public byte getBlueAbs(int n) {
        return this.data[n * this.isize + 2];
    }

    public <T extends Dataset> T createGreyDataset(Class<T> clazz) {
        return this.createGreyDataset(clazz, 0.299, 0.587, 0.114);
    }

    public <T extends Dataset> T createGreyDataset(Class<T> clazz, double red, double green, double blue) {
        T grey = DatasetFactory.zeros(clazz, this.shape);
        IndexIterator it = this.getIterator();
        int i = 0;
        while (it.hasNext()) {
            grey.setObjectAbs(i++, red * (double)Byte.toUnsignedInt(this.data[it.index]) + green * (double)Byte.toUnsignedInt(this.data[it.index + 1]) + blue * (double)Byte.toUnsignedInt(this.data[it.index + 2]));
        }
        return grey;
    }

    @Deprecated
    public Dataset createGreyDataset(int dtype) {
        return this.createGreyDataset(0.299, 0.587, 0.114, dtype);
    }

    @Deprecated
    public Dataset createGreyDataset(double red, double green, double blue, int dtype) {
        return this.createGreyDataset(DTypeUtils.getInterface(dtype), red, green, blue);
    }

    public <T extends Dataset> T createRedDataset(Class<T> clazz) {
        return this.createColourChannelDataset(0, clazz, "red");
    }

    public <T extends Dataset> T createGreenDataset(Class<T> clazz) {
        return this.createColourChannelDataset(1, clazz, "green");
    }

    public <T extends Dataset> T createBlueDataset(Class<T> clazz) {
        return this.createColourChannelDataset(2, clazz, "blue");
    }

    @Deprecated
    public Dataset createRedDataset(int dtype) {
        return this.createColourChannelDataset(0, DTypeUtils.getInterface(dtype), "red");
    }

    @Deprecated
    public Dataset createGreenDataset(int dtype) {
        return this.createColourChannelDataset(1, DTypeUtils.getInterface(dtype), "green");
    }

    @Deprecated
    public Dataset createBlueDataset(int dtype) {
        return this.createColourChannelDataset(2, DTypeUtils.getInterface(dtype), "blue");
    }

    private <T extends Dataset> T createColourChannelDataset(int channelOffset, Class<T> clazz, String cName) {
        StringBuilder cname;
        T channel = DatasetFactory.zeros(clazz, this.shape);
        StringBuilder stringBuilder = cname = this.name == null ? new StringBuilder() : new StringBuilder(this.name);
        if (cname.length() > 0) {
            cname.append('.');
        }
        cname.append(cName);
        channel.setName(cname.toString());
        IndexIterator it = this.getIterator();
        int i = 0;
        while (it.hasNext()) {
            channel.setObjectAbs(i++, Byte.toUnsignedInt(this.data[it.index + channelOffset]));
        }
        return channel;
    }

    public ByteDataset getRedView() {
        return this.getColourChannelView(0, "red");
    }

    public ByteDataset getGreenView() {
        return this.getColourChannelView(1, "green");
    }

    public ByteDataset getBlueView() {
        return this.getColourChannelView(2, "blue");
    }

    private ByteDataset getColourChannelView(int channelOffset, String cName) {
        ByteDataset view = this.getElements(channelOffset);
        view.setName(cName);
        return view;
    }

    @Override
    public Number max(boolean ... ignored) {
        int max = 0;
        IndexIterator it = this.getIterator();
        while (it.hasNext()) {
            int i = 0;
            while (i < 3) {
                int value = Byte.toUnsignedInt(this.data[it.index + i]);
                if (value > max) {
                    max = value;
                }
                ++i;
            }
        }
        return max;
    }

    @Override
    public Number min(boolean ... ignored) {
        int min = 255;
        IndexIterator it = this.getIterator();
        while (it.hasNext()) {
            int i = 0;
            while (i < 3) {
                int value = Byte.toUnsignedInt(this.data[it.index + i]);
                if (value < min) {
                    min = value;
                }
                ++i;
            }
        }
        return min;
    }
}

