/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.nosql;

import java.util.logging.Logger;

public enum NoSQLType {
    KEY_VALUE(1),
    COLUMN(2),
    DOCUMENT(3),
    GRAPH(4),
    OTHER(0);

    public static final String DATABASE_TYPE_PROPERTY = "jakarta.nosql.database.type";
    public static final String DEFAULT_DATABASE_TYPE = "KEY_VALUE";
    private static final Logger LOGGER;
    private final int flexibility;

    private NoSQLType(int flexibility) {
        this.flexibility = flexibility;
    }

    public int getFlexibility() {
        return this.flexibility;
    }

    public static NoSQLType get() {
        String type = System.getProperty(DATABASE_TYPE_PROPERTY);
        LOGGER.info("Getting the NoSQL type: " + type + " from the system property: jakarta.nosql.database.type");
        if (type == null) {
            LOGGER.info("No NoSQL type found in the system property: jakarta.nosql.database.type. Using the default type: KEY_VALUE");
            type = DEFAULT_DATABASE_TYPE;
            return NoSQLType.get(type);
        }
        return NoSQLType.get(type);
    }

    public static NoSQLType get(String type) {
        LOGGER.info("Getting the NoSQL type: " + type);
        try {
            return NoSQLType.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOGGER.warning("No NoSQL type found for: " + type + ". Using the default type: KEY_VALUE");
            return NoSQLType.valueOf(DEFAULT_DATABASE_TYPE);
        }
    }

    static {
        LOGGER = Logger.getLogger(NoSQLType.class.getName());
    }
}

