/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.collab.cdo.repository;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.net4j.CDOSessionConfiguration;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.mylyn.docs.intent.collab.cdo.adapters.CDOAdapter;
import org.eclipse.mylyn.docs.intent.collab.cdo.repository.CDOConfig;
import org.eclipse.mylyn.docs.intent.collab.handlers.RepositoryClient;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryStructurer;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.collab.repository.RepositoryConnectionException;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.channel.ChannelException;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;

public class CDORepository
implements Repository {
    public static final String CDO_REPOSITORY_IDENTIFIER = "cdo://";
    private static Set<CDORepository> activeRepositories = new LinkedHashSet<CDORepository>();
    private IConnector connector;
    private IManagedContainer container;
    private CDOSessionConfiguration cdoSessionConfiguration;
    private CDOSession session;
    private CDOConfig repositoryConfiguration;
    private Set<RepositoryClient> clientRegistry;

    public CDORepository(CDOSession cdoSession) {
        this.clientRegistry = new LinkedHashSet<RepositoryClient>();
        this.session = cdoSession;
    }

    public CDORepository(CDOConfig configuration) {
        this.repositoryConfiguration = configuration;
        this.clientRegistry = new LinkedHashSet<RepositoryClient>();
    }

    public void register(RepositoryClient client) {
        this.clientRegistry.add(client);
    }

    public void unregister(RepositoryClient client) {
        this.clientRegistry.remove(client);
        if (this.clientRegistry.isEmpty()) {
            this.closeSession();
        }
    }

    public Object getOrCreateSession() throws RepositoryConnectionException {
        if (this.cdoSessionConfiguration == null && this.session == null) {
            CDOUtil.setLegacyModeDefault((boolean)true);
            this.container = ContainerUtil.createContainer();
            Net4jUtil.prepareContainer((IManagedContainer)this.container);
            TCPUtil.prepareContainer((IManagedContainer)this.container);
            CDONet4jUtil.prepareContainer((IManagedContainer)this.container);
            this.container.activate();
            this.connector = TCPUtil.getConnector((IManagedContainer)this.container, (String)this.repositoryConfiguration.getServerAdress());
            this.cdoSessionConfiguration = CDONet4jUtil.createSessionConfiguration();
            this.cdoSessionConfiguration.setConnector(this.connector);
            this.cdoSessionConfiguration.setRepositoryName(this.repositoryConfiguration.getRepositoryName());
        }
        if (this.session == null || this.session.isClosed()) {
            try {
                this.session = this.cdoSessionConfiguration.openSession();
            }
            catch (TimeoutRuntimeException tre) {
                throw new RepositoryConnectionException(tre.getMessage());
            }
            catch (ChannelException ce) {
                throw new RepositoryConnectionException(ce.getMessage());
            }
        }
        if (!activeRepositories.contains(this)) {
            activeRepositories.add(this);
        }
        return this.session;
    }

    public void closeSession() {
        activeRepositories.remove(this);
        if (activeRepositories.isEmpty() && this.session != null) {
            this.session.close();
            this.session = null;
            this.connector.close();
            this.connector = null;
            this.container.deactivate();
            this.container = null;
            this.cdoSessionConfiguration = null;
        }
    }

    public CDOConfig getConfiguration() {
        return this.repositoryConfiguration;
    }

    public EPackage.Registry getPackageRegistry() throws RepositoryConnectionException {
        return ((CDOSession)this.getOrCreateSession()).getPackageRegistry();
    }

    public RepositoryAdapter createRepositoryAdapter() {
        try {
            return new CDOAdapter(this, (CDOSession)this.getOrCreateSession());
        }
        catch (RepositoryConnectionException repositoryConnectionException) {
            return null;
        }
    }

    public void setRepositoryStructurer(RepositoryStructurer structurer) {
    }

    public String getIdentifier() {
        return CDO_REPOSITORY_IDENTIFIER + this.repositoryConfiguration.getRepositoryName();
    }

    public String getRepositoryLocation() {
        return this.getIdentifier();
    }

    public URI getRepositoryURI() {
        return URI.createURI((String)this.getIdentifier());
    }
}

