/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.compiler.generator.modelgeneration;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.mylyn.docs.intent.client.compiler.errors.InvalidValueException;
import org.eclipse.mylyn.docs.intent.client.compiler.generator.modelgeneration.ModelingUnitGenerator;
import org.eclipse.mylyn.docs.intent.client.compiler.generator.modellinking.ModelingUnitLinkResolver;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationMessageType;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatusSeverity;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilerFactory;
import org.eclipse.mylyn.docs.intent.core.document.IntentGenericElement;
import org.eclipse.mylyn.docs.intent.core.document.UnitInstruction;
import org.eclipse.mylyn.docs.intent.core.modelingunit.NativeValue;
import org.eclipse.mylyn.docs.intent.core.modelingunit.StructuralFeatureAffectation;

public final class NativeValueGenerator {
    private NativeValueGenerator() {
    }

    public static Object generate(NativeValue valueInstruction, ModelingUnitLinkResolver linkResolver, ModelingUnitGenerator modelingUnitGenerator) {
        ModelingUnitGenerator.clearCompilationStatus((IntentGenericElement)valueInstruction);
        String typeName = ((StructuralFeatureAffectation)valueInstruction.eContainer()).getMetaType().getTypeName();
        Object generatedValue = NativeValueGenerator.generateCorrectValueAccordingToType(valueInstruction, linkResolver, typeName);
        if (generatedValue == null) {
            throw new InvalidValueException((UnitInstruction)valueInstruction, "The value " + valueInstruction.getValue() + " is invalid for type " + typeName);
        }
        return generatedValue;
    }

    private static Object generateCorrectValueAccordingToType(NativeValue valueInstruction, ModelingUnitLinkResolver linkResolver, String typeName) {
        valueInstruction.getCompilationStatus().clear();
        Object generatedValue = null;
        try {
            if ("EInt".equals(typeName)) {
                generatedValue = NativeValueGenerator.generateEInt(valueInstruction.getValue());
            }
            if ("EString".equals(typeName)) {
                generatedValue = NativeValueGenerator.generateEString(valueInstruction.getValue());
            }
            if ("EBoolean".equals(typeName)) {
                generatedValue = NativeValueGenerator.generateEBoolean(valueInstruction.getValue());
            }
        }
        catch (NumberFormatException numberFormatException) {
            CompilationStatus status = CompilerFactory.eINSTANCE.createCompilationStatus();
            status.setMessage("Invalid value for " + valueInstruction.getValue() + " : expecting " + typeName);
            status.setSeverity(CompilationStatusSeverity.WARNING);
            status.setTarget((IntentGenericElement)valueInstruction);
            status.setType(CompilationMessageType.INVALID_VALUE_ERROR);
            valueInstruction.getCompilationStatus().add((Object)status);
        }
        if (generatedValue == null) {
            EClassifier type = linkResolver.resolveEClassifierUsingPackageRegistry((UnitInstruction)valueInstruction, typeName);
            if (type instanceof EEnum) {
                EEnum typeAsEnum = (EEnum)type;
                EEnumLiteral eEnumLiteralByLiteral = typeAsEnum.getEEnumLiteralByLiteral(NativeValueGenerator.removeQuotes(valueInstruction.getValue()));
                if (eEnumLiteralByLiteral != null) {
                    generatedValue = eEnumLiteralByLiteral.getInstance();
                } else {
                    CompilationStatus status = CompilerFactory.eINSTANCE.createCompilationStatus();
                    status.setMessage("Invalid literal value '" + valueInstruction.getValue() + "' : expecting one of " + typeAsEnum.getELiterals());
                    status.setSeverity(CompilationStatusSeverity.ERROR);
                    status.setTarget((IntentGenericElement)valueInstruction);
                    status.setType(CompilationMessageType.INVALID_VALUE_ERROR);
                    valueInstruction.getCompilationStatus().add((Object)status);
                }
            } else if (type instanceof EDataType) {
                EDataType typeAsDataType = (EDataType)type;
                if (typeAsDataType.getInstanceClass().equals(Integer.class)) {
                    generatedValue = NativeValueGenerator.generateEInt(valueInstruction.getValue());
                }
                if (typeAsDataType.getInstanceClass().equals(String.class)) {
                    generatedValue = NativeValueGenerator.generateEString(valueInstruction.getValue());
                }
                if (typeAsDataType.getInstanceClass().equals(Boolean.class)) {
                    generatedValue = NativeValueGenerator.generateEBoolean(valueInstruction.getValue());
                }
            }
        }
        return generatedValue;
    }

    private static Integer generateEInt(String value) {
        return Integer.parseInt(NativeValueGenerator.removeQuotes(value));
    }

    private static String generateEString(String value) {
        return NativeValueGenerator.removeQuotes(value);
    }

    private static Boolean generateEBoolean(String value) {
        return Boolean.parseBoolean(NativeValueGenerator.removeQuotes(value));
    }

    private static String removeQuotes(String value) {
        return value.replace("\"", "");
    }
}

