/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.annotation;

import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.IntentAnnotation;
import org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.IntentAnnotationMessageType;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationMessageType;
import org.eclipse.mylyn.docs.intent.core.compiler.CompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.SynchronizerCompilationStatus;
import org.eclipse.mylyn.docs.intent.core.compiler.SynchronizerResourceState;

public final class IntentAnnotationFactory {
    public static final String EMPTY_WORKING_COPY_RESOURCE_TAG = "EMPTY_WORKING_COPY_RESOURCE";
    public static final String EMPTY_DOCUMENT_RESOURCE_TAG = "EMPTY_DOCUMENT_RESOURCE";
    public static final String NULL_RESOURCE_TAG = "NULL_RESOURCE";
    public static final String DIFF_RESOURCE_TAG = "DIFF_RESOURCE";
    public static final String INTENT_ANNOT_COMPILER_ERROR = "org.eclipse.mylyn.docs.intent.client.ui.annotation.compiler.error";
    public static final String INTENT_ANNOT_COMPILER_WARNING = "org.eclipse.mylyn.docs.intent.client.ui.annotation.compiler.warning";
    public static final String INTENT_ANNOT_GENERAL_INFO = "org.eclipse.mylyn.docs.intent.client.ui.annotation.info";
    public static final String INTENT_ANNOT_SYNTAX_ERROR = "org.eclipse.mylyn.docs.intent.client.ui.annotation.syntaxerror";
    public static final String INTENT_ANNOT_SYNC_WARNING = "org.eclipse.mylyn.docs.intent.client.ui.annotation.sync.warning";

    private IntentAnnotationFactory() {
    }

    public static Annotation createAnnotationFromCompilationStatus(URI targetURI, CompilationStatus compilationStatus) {
        IntentAnnotation annotation = new IntentAnnotation(true);
        IntentAnnotationMessageType annotationMessageType = null;
        switch (compilationStatus.getSeverity()) {
            case ERROR: {
                annotation.setType(INTENT_ANNOT_COMPILER_ERROR);
                annotationMessageType = IntentAnnotationMessageType.COMPILER_ERROR;
                break;
            }
            case WARNING: {
                if (compilationStatus.getType() == CompilationMessageType.SYNCHRONIZER_WARNING) {
                    annotation.setType(INTENT_ANNOT_SYNC_WARNING);
                    SynchronizerCompilationStatus syncStatus = (SynchronizerCompilationStatus)compilationStatus;
                    LinkedHashSet<String> additionalInformations = new LinkedHashSet<String>();
                    if (SynchronizerResourceState.EMPTY.equals((Object)syncStatus.getCompiledResourceState())) {
                        additionalInformations.add(EMPTY_DOCUMENT_RESOURCE_TAG);
                    } else if (SynchronizerResourceState.EMPTY.equals((Object)syncStatus.getWorkingCopyResourceState())) {
                        additionalInformations.add(EMPTY_WORKING_COPY_RESOURCE_TAG);
                    } else if (SynchronizerResourceState.NULL.equals((Object)syncStatus.getWorkingCopyResourceState())) {
                        additionalInformations.add(NULL_RESOURCE_TAG);
                    } else {
                        additionalInformations.add(DIFF_RESOURCE_TAG);
                    }
                    additionalInformations.add(syncStatus.getWorkingCopyResourceURI());
                    if (targetURI != null) {
                        additionalInformations.add(targetURI.toString());
                    }
                    annotation.setAdditionalInformations(additionalInformations);
                    annotationMessageType = IntentAnnotationMessageType.SYNC_WARNING;
                    break;
                }
                annotation.setType(INTENT_ANNOT_COMPILER_WARNING);
                annotationMessageType = IntentAnnotationMessageType.COMPILER_INFO;
                break;
            }
            default: {
                annotation.setType(INTENT_ANNOT_GENERAL_INFO);
                annotationMessageType = IntentAnnotationMessageType.COMPILER_INFO;
            }
        }
        annotation.setText(compilationStatus.getMessage());
        annotation.setMessageType(annotationMessageType);
        return annotation;
    }

    public static IntentAnnotation createSyntaxErrorAnnotation() {
        IntentAnnotation annotation = new IntentAnnotation(true);
        annotation.setType(INTENT_ANNOT_SYNTAX_ERROR);
        annotation.setMessageType(IntentAnnotationMessageType.PARSER_ERROR);
        return annotation;
    }
}

